/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtHandler;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.function.Predicate;

final class BulkheadHandler
extends FtHandler {
    BulkheadHandler(RegistryCodegenContext ctx) {
        super(ctx, FtTypes.BULKHEAD_ANNOTATION);
    }

    @Override
    void process(RegistryRoundContext roundContext, TypeInfo enclosingType, TypedElementInfo element, Annotation annotation, TypeName generatedType, ClassModel.Builder classModel) {
        TypeName enclosingTypeName = enclosingType.typeName();
        ((ClassModel.Builder)classModel.superType(FtTypes.BULKHEAD_GENERATED_METHOD)).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(DeclarativeTypes.WEIGHT)).putValue("value", (Object)20.0)).build());
        this.bulkheadBody(classModel, enclosingTypeName, element, generatedType, element.elementName(), annotation);
        this.addType(roundContext, generatedType, classModel, enclosingTypeName, element);
    }

    private void bulkheadBody(ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element, TypeName generatedType, String methodName, Annotation annotation) {
        classModel.addField(bulkhead -> bulkhead.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(FtTypes.BULKHEAD).name("bulkhead"));
        String name = annotation.stringValue("name").filter(Predicate.not(String::isBlank)).orElse(null);
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE);
        if (name == null) {
            ctr.addContentLine("this.bulkhead = produceBulkhead();");
        } else {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addParameter(namedBulkhead -> ((Parameter.Builder)namedBulkhead.name("namedBulkhead")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.OPTIONAL)).addTypeArgument(FtTypes.BULKHEAD)).build()).addAnnotation(this.namedAnnotation(name)))).addContent("this.bulkhead = namedBulkhead.orElseGet(")).addContent(generatedType)).addContentLine("::produceBulkhead);");
        }
        classModel.addConstructor(ctr);
        classModel.addMethod(bulkhead -> ((Method.Builder)((Method.Builder)((Method.Builder)bulkhead.name("bulkhead")).addAnnotation(Annotations.OVERRIDE)).returnType(FtTypes.BULKHEAD).accessModifier(AccessModifier.PROTECTED)).addContentLine("return bulkhead;"));
        String customName = name == null ? enclosingTypeName.fqName() + "." + element.signature().text() : name + "-" + enclosingTypeName.fqName() + "." + element.signature().text();
        classModel.addMethod(produceBulkhead -> ((Method.Builder)((Method.Builder)produceBulkhead.accessModifier(AccessModifier.PRIVATE)).isStatic(true).returnType(FtTypes.BULKHEAD).name("produceBulkhead")).update(builder -> this.produceBulkheadMethodBody(enclosingTypeName, element, (Method.Builder)builder, annotation, customName)));
    }

    private void produceBulkheadMethodBody(TypeName typeName, TypedElementInfo element, Method.Builder builder, Annotation annotation, String customName) {
        int limit = annotation.intValue("limit").orElse(10);
        int queueLength = annotation.intValue("queueLength").orElse(10);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("return ")).addContent(FtTypes.BULKHEAD)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".name(\"")).addContent(customName)).addContentLine("\")")).addContent(".queueLength(")).addContent(String.valueOf(queueLength))).addContentLine(")")).addContent(".limit(")).addContent(String.valueOf(limit))).addContentLine(")")).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
    }
}

