/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.http.webserver;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.declarative.codegen.http.HttpFields;
import io.helidon.declarative.codegen.http.HttpTypes;
import io.helidon.declarative.codegen.http.webserver.AbstractParametersProvider;
import io.helidon.declarative.codegen.http.webserver.ParameterCodegenContext;
import io.helidon.declarative.codegen.http.webserver.spi.HttpParameterCodegenProvider;
import io.helidon.service.codegen.DefaultsCodegen;
import io.helidon.service.codegen.DefaultsParams;
import io.helidon.service.codegen.FieldHandler;
import java.util.Optional;

class ParamProviderHttpHeader
extends AbstractParametersProvider
implements HttpParameterCodegenProvider {
    ParamProviderHttpHeader() {
    }

    @Override
    public boolean codegen(ParameterCodegenContext ctx) {
        Optional<Annotation> first = ctx.annotations().stream().filter(it -> HttpTypes.HTTP_HEADER_PARAM_ANNOTATION.equals((Object)it.typeName())).findFirst();
        if (first.isEmpty()) {
            return false;
        }
        Annotation headerParam = first.get();
        String headerParamName = (String)headerParam.value().orElseThrow(() -> new CodegenException("@HeaderParam annotation must have a value."));
        FieldHandler fieldHandler = ctx.fieldHandler();
        String headerConstantName = HttpFields.ensureHeaderNameConstant(fieldHandler, headerParamName);
        TypeName parameterType = ctx.parameterType();
        TypeName realType = parameterType.isOptional() ? (TypeName)parameterType.typeArguments().getFirst() : parameterType;
        Optional defaultCode = DefaultsCodegen.findDefault(ctx.annotations(), (TypeName)realType);
        ContentBuilder<?> contentBuilder = ctx.contentBuilder();
        String serverRequestParamName = ctx.serverRequestParamName();
        contentBuilder.addContent(serverRequestParamName).addContent(".headers()");
        if (parameterType.isOptional() || defaultCode.isPresent()) {
            contentBuilder.addContent(".find(").addContent(headerConstantName).addContentLine(")").addContent(".map(it -> it.");
            this.getMethod(contentBuilder, realType);
            contentBuilder.addContentLine(")");
            if (defaultCode.isPresent()) {
                DefaultsCodegen.DefaultCode defaultInfo = (DefaultsCodegen.DefaultCode)defaultCode.get();
                if (defaultInfo.requiresMapper()) {
                    this.ensureMapperField(ctx);
                }
                DefaultsParams params = ((DefaultsParams.Builder)((DefaultsParams.Builder)((DefaultsParams.Builder)DefaultsParams.builder().contextField(ctx.serverRequestParamName() + ".headers()")).mapperQualifier("headers")).mappersField("mappers")).build();
                DefaultsCodegen.codegenOptional(contentBuilder, (DefaultsCodegen.DefaultCode)defaultInfo, (FieldHandler)fieldHandler, (DefaultsParams)params);
                contentBuilder.addContentLine(";");
            }
        } else {
            contentBuilder.addContent(".get(").addContent(headerConstantName).addContent(").");
            this.getMethod(contentBuilder, parameterType);
            contentBuilder.addContentLine(";");
        }
        return true;
    }
}

