/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.Builder;
import io.helidon.common.config.Config;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementType;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class DbClientServiceBase
implements DbClientService {
    private final Predicate<DbClientServiceContext> predicate;

    protected DbClientServiceBase(BuilderBase<?, ?> builder) {
        this.predicate = builder.predicate();
    }

    @Override
    public final DbClientServiceContext statement(DbClientServiceContext context) {
        if (this.predicate.test(context)) {
            return this.apply(context);
        }
        return context;
    }

    protected abstract DbClientServiceContext apply(DbClientServiceContext var1);

    public static abstract class BuilderBase<B extends BuilderBase<B, T>, T extends DbClientServiceBase>
    implements Builder<B, T> {
        private static final Predicate<DbClientServiceContext> YES = it -> true;
        private static final Predicate<DbClientServiceContext> NO = it -> false;
        private final Set<String> statementNames = new LinkedHashSet<String>();
        private final Set<DbStatementType> statementTypes = EnumSet.noneOf(DbStatementType.class);
        private Predicate<DbClientServiceContext> predicate;
        private boolean enabled = true;

        protected BuilderBase() {
        }

        public B config(Config config) {
            config.get("statement-names").asList(String.class).ifPresent(this::statementNames);
            config.get("statement-types").asNodeList().ifPresent(nodes -> this.statementTypes(nodes.stream().map(cfg -> DbStatementType.valueOf((String)cfg.asString().get())).toList()));
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return (B)((BuilderBase)this.identity());
        }

        public B statementPredicate(Predicate<DbClientServiceContext> predicate) {
            this.predicate = predicate;
            return (B)((BuilderBase)this.identity());
        }

        public B statementTypes(DbStatementType ... types) {
            return this.statementTypes(List.of(types));
        }

        public B statementNames(String ... names) {
            return this.statementNames(List.of(names));
        }

        public void enabled(boolean enabled) {
            this.enabled = enabled;
        }

        protected B statementTypes(List<DbStatementType> types) {
            this.statementTypes.addAll(types);
            return (B)((BuilderBase)this.identity());
        }

        protected B statementNames(List<String> names) {
            this.statementNames.addAll(names);
            return (B)((BuilderBase)this.identity());
        }

        protected Set<String> statementNames() {
            return this.statementNames;
        }

        protected Set<DbStatementType> statementTypes() {
            return this.statementTypes;
        }

        protected Predicate<DbClientServiceContext> predicate() {
            if (!this.enabled) {
                return NO;
            }
            if (null != this.predicate) {
                return this.predicate;
            }
            List<Pattern> namePatterns = this.statementNames.stream().map(Pattern::compile).toList();
            EnumSet<DbStatementType> types = EnumSet.copyOf(this.statementTypes);
            Predicate<DbClientServiceContext> namePredicate = namePatterns.isEmpty() ? YES : it -> {
                String statementName = it.statementName();
                for (Pattern namePattern : namePatterns) {
                    if (!namePattern.matcher(statementName).matches()) continue;
                    return true;
                }
                return false;
            };
            Predicate<DbClientServiceContext> typePredicate = types.isEmpty() ? YES : it -> types.contains((Object)it.statementType());
            return context -> namePredicate.test((DbClientServiceContext)context) && typePredicate.test((DbClientServiceContext)context);
        }
    }
}

