/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.context.Context;
import io.helidon.dbclient.DbClientServiceContextImpl;
import io.helidon.dbclient.DbStatementType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface DbClientServiceContext {
    public static DbClientServiceContext create(String dbType) {
        return new DbClientServiceContextImpl(dbType);
    }

    public String dbType();

    public Context context();

    public String statementName();

    public String statement();

    public CompletionStage<Void> statementFuture();

    public CompletionStage<Long> resultFuture();

    public Optional<List<Object>> indexedParameters();

    public Optional<Map<String, Object>> namedParameters();

    public boolean isIndexed();

    public boolean isNamed();

    public DbStatementType statementType();

    public DbClientServiceContext context(Context var1);

    public DbClientServiceContext statementName(String var1);

    public DbClientServiceContext statementFuture(CompletionStage<Void> var1);

    public DbClientServiceContext resultFuture(CompletionStage<Long> var1);

    public DbClientServiceContext statement(String var1, List<Object> var2);

    public DbClientServiceContext statement(String var1, Map<String, Object> var2);

    public DbClientServiceContext parameters(List<Object> var1);

    public DbClientServiceContext parameters(Map<String, Object> var1);

    public DbClientServiceContext statementType(DbStatementType var1);
}

