/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.dbclient.DbMapper;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

class DbMapperManagerImpl
implements DbMapperManager {
    public static final String ERROR_NO_MAPPER_FOUND = "Failed to find DB mapper.";
    private final List<DbMapperProvider> providers;
    private final Map<Class<?>, DbMapper<?>> byClass = new ConcurrentHashMap();
    private final Map<GenericType<?>, DbMapper<?>> byType = new ConcurrentHashMap();

    DbMapperManagerImpl(DbMapperManager.Builder builder) {
        this.providers = builder.mapperProviders();
    }

    @Override
    public <T> T read(DbRow row, Class<T> expectedType) {
        return (T)this.executeMapping(() -> this.findMapper(expectedType, false).read(row), row, TYPE_DB_ROW, GenericType.create(expectedType));
    }

    @Override
    public <T> T read(DbRow row, GenericType<T> expectedType) {
        return (T)this.executeMapping(() -> this.findMapper(expectedType, false).read(row), row, TYPE_DB_ROW, expectedType);
    }

    @Override
    public <T> Map<String, ?> toNamedParameters(T value, Class<T> valueClass) {
        return this.executeMapping(() -> this.findMapper(valueClass, false).toNamedParameters(value), value, GenericType.create(valueClass), TYPE_NAMED_PARAMS);
    }

    @Override
    public <T> List<?> toIndexedParameters(T value, Class<T> valueClass) {
        return this.executeMapping(() -> this.findMapper(valueClass, false).toIndexedParameters(value), value, GenericType.create(valueClass), TYPE_INDEXED_PARAMS);
    }

    private <T> T executeMapping(Supplier<T> mapping, Object source, GenericType<?> sourceType, GenericType<?> targetType) {
        try {
            return mapping.get();
        }
        catch (MapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createMapperException(source, sourceType, targetType, e);
        }
    }

    private <T> DbMapper<T> findMapper(Class<T> type, boolean fromTypes) {
        DbMapper mapper = this.byClass.computeIfAbsent(type, aClass -> this.fromProviders(type).orElseGet(() -> {
            GenericType targetType = GenericType.create((Class)type);
            if (fromTypes) {
                return DbMapperManagerImpl.notFoundMapper(targetType);
            }
            return this.findMapper(targetType, true);
        }));
        return mapper;
    }

    private <T> DbMapper<T> findMapper(GenericType<T> type, boolean fromClasses) {
        DbMapper mapper = this.byType.computeIfAbsent(type, aType -> this.fromProviders(type).orElseGet(() -> {
            if (!fromClasses && type.isClass()) {
                return this.findMapper(type.rawType(), true);
            }
            return DbMapperManagerImpl.notFoundMapper(type);
        }));
        return mapper;
    }

    private <T> Optional<DbMapper<T>> fromProviders(Class<T> type) {
        return this.providers.stream().flatMap(provider -> provider.mapper(type).stream()).findFirst();
    }

    private <T> Optional<DbMapper<T>> fromProviders(GenericType<T> type) {
        return this.providers.stream().flatMap(provider -> provider.mapper(type).stream()).findFirst();
    }

    private RuntimeException createMapperException(Object source, GenericType<?> sourceType, GenericType<?> targetType, Throwable throwable) {
        throw new MapperException(sourceType, targetType, "Failed to map source of class '" + source.getClass().getName() + "'", throwable);
    }

    private static <T> DbMapper<T> notFoundMapper(final GenericType<T> type) {
        return new DbMapper<T>(){

            @Override
            public T read(DbRow row) {
                throw new MapperException(DbMapperManager.TYPE_DB_ROW, type, DbMapperManagerImpl.ERROR_NO_MAPPER_FOUND);
            }

            @Override
            public Map<String, ?> toNamedParameters(T value) {
                throw new MapperException(type, DbMapperManager.TYPE_NAMED_PARAMS, DbMapperManagerImpl.ERROR_NO_MAPPER_FOUND);
            }

            @Override
            public List<?> toIndexedParameters(T value) {
                throw new MapperException(type, DbMapperManager.TYPE_INDEXED_PARAMS, DbMapperManagerImpl.ERROR_NO_MAPPER_FOUND);
            }
        };
    }
}

