/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.tracing;

import io.helidon.common.config.Config;
import io.helidon.common.context.Context;
import io.helidon.dbclient.DbClientServiceBase;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import java.util.Map;

public class DbClientTracing
extends DbClientServiceBase {
    private static final Tag<? super String> DBCLIENT_TAG = Tag.COMPONENT.create((Object)"dbclient");

    private DbClientTracing(Builder builder) {
        super((DbClientServiceBase.BuilderBase)builder);
    }

    public static DbClientTracing create(Config config) {
        return ((Builder)DbClientTracing.builder().config(config)).build();
    }

    public static DbClientTracing create() {
        return DbClientTracing.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected DbClientServiceContext apply(DbClientServiceContext serviceContext) {
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"dbclient", (String)"statement");
        if (!spanConfig.enabled()) {
            return serviceContext;
        }
        Context context = serviceContext.context();
        Tracer tracer = context.get(Tracer.class).orElseGet(Tracer::global);
        Span.Builder spanBuilder = tracer.spanBuilder(serviceContext.statementName());
        context.get(SpanContext.class).ifPresent(arg_0 -> ((Span.Builder)spanBuilder).parent(arg_0));
        Span span = spanBuilder.start();
        span.tag("db.operation", serviceContext.statementType().toString());
        if (spanConfig.logEnabled("statement", true)) {
            Tag.DB_STATEMENT.create((Object)serviceContext.statement()).apply(span);
        }
        DBCLIENT_TAG.apply(span);
        Tag.DB_TYPE.create((Object)serviceContext.dbType()).apply(span);
        serviceContext.statementFuture().thenAccept(nothing -> {
            if (spanConfig.logEnabled("statement-finish", true)) {
                span.addEvent("log", Map.of("type", "statement"));
            }
        });
        serviceContext.resultFuture().thenAccept(count -> {
            if (spanConfig.logEnabled("result-finish", true)) {
                span.addEvent("log", Map.of("type", "result", "count", count));
            }
            span.end();
        }).exceptionally(throwable -> {
            span.end(throwable);
            return null;
        });
        return serviceContext;
    }

    public static class Builder
    extends DbClientServiceBase.BuilderBase<Builder, DbClientTracing> {
        private Builder() {
        }

        public DbClientTracing build() {
            return new DbClientTracing(this);
        }
    }
}

