/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientBase;
import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.mongodb.MongoDbClientBuilder;
import io.helidon.dbclient.mongodb.MongoDbClientConfig;
import io.helidon.dbclient.mongodb.MongoDbExecute;
import java.util.Objects;

public class MongoDbClient
extends DbClientBase
implements DbClient {
    private final MongoClient client;
    private final MongoDatabase db;

    MongoDbClient(MongoDbClientBuilder builder) {
        super(((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)DbClientContext.builder().statements(builder.statements())).dbMapperManager(builder.dbMapperManager())).mapperManager(builder.mapperManager())).clientServices(builder.clientServices())).dbType("mongoDb")).build());
        MongoDbClientConfig config = builder.dbConfig();
        ConnectionString connectionString = new ConnectionString(config.url());
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applyConnectionString(connectionString);
        String dbName = connectionString.getDatabase();
        if (config.username() != null || config.password() != null) {
            String credDb = config.credDb() == null ? connectionString.getDatabase() : config.credDb();
            MongoCredential credentials = MongoCredential.createCredential((String)config.username(), (String)Objects.requireNonNull(credDb), (char[])config.password().toCharArray());
            settingsBuilder.credential(credentials);
        }
        this.client = MongoClients.create((MongoClientSettings)settingsBuilder.build());
        this.db = this.client.getDatabase(dbName != null ? dbName : "admin");
    }

    MongoDbClient(MongoDbClientBuilder builder, MongoClient client, MongoDatabase db) {
        super(((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)DbClientContext.builder().statements(builder.statements())).dbMapperManager(builder.dbMapperManager())).mapperManager(builder.mapperManager())).clientServices(builder.clientServices())).dbType("mongoDb")).build());
        this.client = client;
        this.db = db;
    }

    public DbExecute execute() {
        return new MongoDbExecute(this.context(), this.db);
    }

    public DbTransaction transaction() {
        throw new UnsupportedOperationException("Transactions are not supported");
    }

    public String dbType() {
        return "mongoDb";
    }

    public <C> C unwrap(Class<C> cls) {
        if (MongoClient.class.isAssignableFrom(cls)) {
            return cls.cast(this.client);
        }
        if (MongoDatabase.class.isAssignableFrom(cls)) {
            return cls.cast(this.db);
        }
        throw new UnsupportedOperationException(String.format("Class %s is not supported for unwrap", cls.getName()));
    }
}

