/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbRow;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbStatementQuery
extends MongoDbStatement<DbStatementQuery>
implements DbStatementQuery {
    private static final System.Logger LOGGER = System.getLogger(MongoDbStatementQuery.class.getName());

    MongoDbStatementQuery(MongoDatabase db, DbExecuteContext context) {
        super(db, context);
    }

    public DbStatementType statementType() {
        return DbStatementType.QUERY;
    }

    public Stream<DbRow> execute() {
        return (Stream)this.doExecute((future, context) -> {
            String preparedStmt = this.prepareStatement((DbClientServiceContext)context);
            try {
                MongoDbStatement.MongoStatement stmt = this.queryOrCommand(preparedStmt);
                return switch (stmt.getOperation()) {
                    case MongoDbStatement.MongoOperation.QUERY -> this.executeQuery(stmt, (CompletableFuture<Long>)future);
                    case MongoDbStatement.MongoOperation.COMMAND -> this.executeCommand(stmt, (CompletableFuture<Long>)future);
                    default -> throw new UnsupportedOperationException(String.format("Operation %s is not supported by query", stmt.getOperation().toString()));
                };
            }
            catch (Exception e) {
                throw new DbClientException(e.getMessage(), (Throwable)e);
            }
        });
    }

    private MongoDbStatement.MongoStatement queryOrCommand(String statement) {
        try {
            return new MongoDbStatement.MongoStatement(DbStatementType.QUERY, statement);
        }
        catch (IllegalStateException e) {
            try {
                return new MongoDbStatement.MongoStatement(DbStatementType.COMMAND, statement);
            }
            catch (IllegalStateException ignored) {
                throw e;
            }
        }
    }

    private Stream<DbRow> executeCommand(MongoDbStatement.MongoStatement stmt, CompletableFuture<Long> future) {
        Document command = stmt.getQuery();
        LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("Command: %s", command.toString()));
        Document doc = this.db().runCommand((Bson)command);
        future.complete(1L);
        return Stream.of(new MongoDbRow(doc, (DbContext)this.context()));
    }

    private Stream<DbRow> executeQuery(MongoDbStatement.MongoStatement stmt, CompletableFuture<Long> future) {
        MongoCursor it;
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        Document projection = stmt.getProjection();
        LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("Query: %s, Projection: %s", query.toString(), projection != null ? projection : "N/A"));
        FindIterable finder = mc.find((Bson)query);
        if (projection != null) {
            finder = finder.projection((Bson)projection);
        }
        future.complete((it = finder.iterator()).hasNext() ? 1L : 0L);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(it, 16);
        Stream<Document> stream = StreamSupport.stream(spliterator, false);
        return stream.map(doc -> new MongoDbRow((Document)doc, (DbContext)this.context()));
    }
}

