/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbColumn;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

final class MongoDbRow
implements DbRow {
    private final Map<String, DbColumn> columnsByName;
    private final List<DbColumn> columnsList;
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;

    MongoDbRow(DbMapperManager dbMapperManager, MapperManager mapperManager, int size) {
        this.dbMapperManager = dbMapperManager;
        this.mapperManager = mapperManager;
        this.columnsByName = new HashMap<String, DbColumn>(size);
        this.columnsList = new ArrayList<DbColumn>(size);
    }

    MongoDbRow(DbMapperManager dbMapperManager, MapperManager mapperManager) {
        this.dbMapperManager = dbMapperManager;
        this.mapperManager = mapperManager;
        this.columnsByName = new HashMap<String, DbColumn>();
        this.columnsList = new ArrayList<DbColumn>();
    }

    void add(String name, DbColumn column) {
        this.columnsByName.put(name, column);
        this.columnsList.add(column);
    }

    public DbColumn column(String name) {
        return this.columnsByName.get(name);
    }

    public DbColumn column(int index) {
        return this.columnsList.get(index - 1);
    }

    public void forEach(Consumer<? super DbColumn> columnAction) {
        this.columnsByName.values().forEach(columnAction);
    }

    public <T> T as(Class<T> type) {
        return (T)this.dbMapperManager.read((DbRow)this, type);
    }

    public <T> T as(GenericType<T> type) throws MapperException {
        return (T)this.dbMapperManager.read((DbRow)this, type);
    }

    public <T> T as(Function<DbRow, T> mapper) {
        return mapper.apply(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('{');
        for (DbColumn col : this.columnsList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(col.name());
            sb.append(':');
            sb.append(col.value().toString());
        }
        sb.append('}');
        return sb.toString();
    }
}

