/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.mongodb.MongoDbDMLExecutor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;

public class MongoDbStatementDml
extends MongoDbStatement<DbStatementDml, Single<Long>>
implements DbStatementDml {
    private DbStatementType dbStatementType;
    private MongoDbStatement.MongoStatement statement;

    MongoDbStatementDml(MongoDatabase db, DbStatementContext statementContext) {
        super(db, statementContext);
        this.dbStatementType = statementContext.statementType();
    }

    public Single<Long> execute() {
        this.statement = new MongoDbStatement.MongoStatement(this.dbStatementType, READER_FACTORY, this.build());
        switch (this.statement.getOperation()) {
            case INSERT: {
                this.dbStatementType = DbStatementType.INSERT;
                break;
            }
            case UPDATE: {
                this.dbStatementType = DbStatementType.UPDATE;
                break;
            }
            case DELETE: {
                this.dbStatementType = DbStatementType.DELETE;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected value for DML statement: %s", new Object[]{this.statement.getOperation()}));
            }
        }
        return (Single)super.execute();
    }

    protected Single<Long> doExecute(Single<DbClientServiceContext> dbContext, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        return Single.create(MongoDbDMLExecutor.executeDml(this, this.dbStatementType, this.statement, dbContext, statementFuture, queryFuture));
    }

    protected DbStatementType statementType() {
        return this.dbStatementType;
    }
}

