/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.json.Json;

final class StatementParsers {
    private static final Logger LOGGER = Logger.getLogger(StatementParsers.class.getName());

    static String toJson(Object value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return Json.createValue((int)((Number)value).intValue()).toString();
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value)).toString();
        }
        if (value instanceof Double || value instanceof Float) {
            return Json.createValue((double)((Number)value).doubleValue()).toString();
        }
        if (value instanceof BigInteger) {
            return Json.createValue((BigInteger)((BigInteger)value)).toString();
        }
        if (value instanceof BigDecimal) {
            return Json.createValue((BigDecimal)((BigDecimal)value)).toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return Json.createValue((String)String.valueOf(value)).toString();
    }

    private StatementParsers() {
    }

    static StatementParser indexedParser(String statement, List<Object> indexedParams) {
        return new IndexedParser(statement, indexedParams);
    }

    static StatementParser namedParser(String statement, Map<String, Object> indexedParams) {
        return new NamedParser(statement, indexedParams);
    }

    static final class IndexedParser
    extends Parser
    implements StatementParser {
        private static final char PAR_LT = '?';
        private static final Parser.State[][] TRANSITION = new Parser.State[][]{{Parser.State.STATEMENT, Parser.State.STATEMENT, Parser.State.STRING, Parser.State.STATEMENT, Parser.State.STATEMENT}, {Parser.State.STRING, Parser.State.STRING, Parser.State.STATEMENT, Parser.State.STRING, Parser.State.STRING}};
        private static final Parser.Action COPY_ACTION = Parser::copyChar;
        private static final Parser.Action VAAP_ACTION = IndexedParser::nextParam;
        private static final Parser.Action[][] ACTION = new Parser.Action[][]{{COPY_ACTION, COPY_ACTION, COPY_ACTION, VAAP_ACTION, COPY_ACTION}, {COPY_ACTION, COPY_ACTION, COPY_ACTION, COPY_ACTION, COPY_ACTION}};
        private final List<Object> parameters;
        private final ListIterator<Object> parIt;
        private CharClass cl;

        private static void nextParam(Parser parser) {
            if (((IndexedParser)parser).parIt.hasNext()) {
                parser.sb.append(StatementParsers.toJson(((IndexedParser)parser).parIt.next()));
            } else {
                parser.sb.append(parser.c);
            }
        }

        private IndexedParser(String statement, List<Object> parameters) {
            super(statement);
            this.parameters = parameters;
            this.parIt = parameters.listIterator();
            this.cl = null;
        }

        @Override
        public String convert() {
            Parser.State state = Parser.State.STATEMENT;
            int len = this.statement().length();
            for (int i = 0; i < len; ++i) {
                this.c(this.statement().charAt(i));
                this.cl = CharClass.charClass(this.c());
                ACTION[state.ordinal()][this.cl.ordinal()].process(this);
                state = TRANSITION[state.ordinal()][this.cl.ordinal()];
            }
            LOGGER.fine(() -> String.format("Indexed Statement %s", this.sb().toString()));
            return this.sb().toString();
        }

        private static enum CharClass {
            LT,
            NUM,
            DQ,
            QST,
            OTH;


            private static CharClass charClass(char c) {
                if (Character.isLetter(c)) {
                    return LT;
                }
                if (Character.isDigit(c)) {
                    return NUM;
                }
                if (c == '\"') {
                    return DQ;
                }
                if (c == '?') {
                    return QST;
                }
                return OTH;
            }
        }
    }

    static final class NamedParser
    implements StatementParser {
        private static final char PAR_BEG = '$';
        private static final State[][] TRANSITION = new State[][]{{State.STATEMENT, State.STATEMENT, State.STRING, State.STATEMENT, State.PAR_BEG, State.STATEMENT}, {State.STRING, State.STRING, State.STATEMENT, State.STRING, State.STRING, State.STRING}, {State.PARAMETER, State.STATEMENT, State.STRING, State.STATEMENT, State.PAR_BEG, State.STATEMENT}, {State.PARAMETER, State.PARAMETER, State.STATEMENT, State.STATEMENT, State.PAR_BEG, State.STATEMENT}};
        private static final Action[][] ACTION = new Action[][]{{NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::storeCharPos, NamedParser::copyCurrChar}, {NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar, NamedParser::copyCurrChar}, {NamedParser::doNothing, NamedParser::copyStoredChars, NamedParser::copyStoredChars, NamedParser::copyStoredChars, NamedParser::copyStoredCharsStoreCharPos, NamedParser::copyStoredChars}, {NamedParser::doNothing, NamedParser::doNothing, NamedParser::finishParamCopyCurrChar, NamedParser::copyStoredChars, NamedParser::finishParamStoreCharPos, NamedParser::finishParamCopyCurrChar}};
        private final Map<String, ? extends Object> mappings;
        private final String statement;
        private final StringBuilder sb;
        private int curPos;
        private int paramBegPos;
        private CharClass cl;

        static void doNothing(NamedParser parser) {
        }

        static void copyCurrChar(NamedParser parser) {
            parser.sb.append(parser.statement.charAt(parser.curPos));
        }

        static void copyStoredChars(NamedParser parser) {
            parser.sb.append(parser.statement, parser.paramBegPos, parser.curPos + 1);
        }

        private static void storeCharPos(NamedParser parser) {
            parser.paramBegPos = parser.curPos;
        }

        static void copyStoredCharsStoreCharPos(NamedParser parser) {
            parser.sb.append(parser.statement, parser.paramBegPos, parser.curPos);
            parser.paramBegPos = parser.curPos;
        }

        private static void finishParamCopyCurrChar(NamedParser parser) {
            String parName = parser.statement.substring(parser.paramBegPos + 1, parser.curPos);
            if (parser.mappings.containsKey(parName)) {
                parser.sb.append(StatementParsers.toJson(parser.mappings.get(parName)));
                parser.sb.append(parser.statement.charAt(parser.curPos));
            } else {
                parser.sb.append(parser.statement, parser.paramBegPos, parser.curPos + 1);
            }
        }

        private static void finishParamStoreCharPos(NamedParser parser) {
            String parName = parser.statement.substring(parser.paramBegPos + 1, parser.curPos);
            if (parser.mappings.containsKey(parName)) {
                parser.sb.append(StatementParsers.toJson(parser.mappings.get(parName)));
            } else {
                parser.sb.append(parser.statement, parser.paramBegPos, parser.curPos);
            }
            parser.paramBegPos = parser.curPos;
        }

        NamedParser(String statement, Map<String, ? extends Object> mappings) {
            this.statement = statement;
            this.sb = new StringBuilder(statement.length());
            this.mappings = mappings;
            this.cl = null;
        }

        @Override
        public String convert() {
            State state = State.STATEMENT;
            int len = this.statement.length();
            this.curPos = 0;
            while (this.curPos < len) {
                this.cl = CharClass.charClass(this.statement.charAt(this.curPos));
                ACTION[state.ordinal()][this.cl.ordinal()].accept(this);
                state = TRANSITION[state.ordinal()][this.cl.ordinal()];
                ++this.curPos;
            }
            switch (state) {
                case PAR_BEG: {
                    this.sb.append(this.statement, this.paramBegPos, len);
                    break;
                }
                case PARAMETER: {
                    String parName = this.statement.substring(this.paramBegPos + 1, len);
                    if (this.mappings.containsKey(parName)) {
                        this.sb.append(StatementParsers.toJson(this.mappings.get(parName)));
                        break;
                    }
                    this.sb.append(this.statement, this.paramBegPos, len);
                    break;
                }
            }
            LOGGER.fine(() -> String.format("Named Statement %s", this.sb.toString()));
            return this.sb.toString();
        }

        private static enum CharClass {
            LETTER,
            NUMBER,
            QUOTE,
            COLON,
            DOLLAR,
            OTHER;


            private static CharClass charClass(char c) {
                switch (c) {
                    case '\"': {
                        return QUOTE;
                    }
                    case '$': {
                        return DOLLAR;
                    }
                    case ':': {
                        return COLON;
                    }
                }
                return Character.isLetter(c) ? LETTER : (Character.isDigit(c) ? NUMBER : OTHER);
            }
        }

        static enum State {
            STATEMENT,
            STRING,
            PAR_BEG,
            PARAMETER;

        }

        private static interface Action
        extends Consumer<NamedParser> {
        }
    }

    static abstract class Parser {
        private final String statement;
        private final StringBuilder sb;
        private final StringBuilder nap;
        private char c;

        static void doNothing(Parser parser) {
        }

        static void copyChar(Parser parser) {
            parser.sb.append(parser.c);
        }

        private Parser(String statement) {
            this.sb = new StringBuilder(statement.length());
            this.nap = new StringBuilder(32);
            this.statement = statement;
            this.c = '\u0000';
        }

        String statement() {
            return this.statement;
        }

        StringBuilder sb() {
            return this.sb;
        }

        StringBuilder nap() {
            return this.nap;
        }

        char c() {
            return this.c;
        }

        void c(char newC) {
            this.c = newC;
        }

        static enum State {
            STATEMENT,
            STRING,
            PAR_BEG,
            PARAMETER;

        }

        @FunctionalInterface
        static interface Action {
            public void process(Parser var1);
        }
    }

    @FunctionalInterface
    static interface StatementParser {
        public String convert();
    }
}

