/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.common.DbClientContext;
import io.helidon.dbclient.mongodb.MongoDbClientConfig;
import io.helidon.dbclient.mongodb.MongoDbClientProviderBuilder;
import io.helidon.dbclient.mongodb.MongoDbExecute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MongoDbClient
implements DbClient {
    private final MongoDbClientConfig config;
    private final MongoClient client;
    private final MongoDatabase db;
    private final ConnectionString connectionString;
    private final DbClientContext clientContext;

    MongoDbClient(MongoDbClientProviderBuilder builder) {
        this.clientContext = ((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)((DbClientContext.Builder)DbClientContext.builder().dbMapperManager(builder.dbMapperManager())).mapperManager(builder.mapperManager())).clientServices(builder.clientServices())).statements(builder.statements())).build();
        this.config = builder.dbConfig();
        this.connectionString = new ConnectionString(this.config.url());
        this.client = this.initMongoClient();
        this.db = this.initMongoDatabase();
    }

    public <U, T extends Subscribable<U>> T inTransaction(Function<DbTransaction, T> executor) {
        throw new UnsupportedOperationException("Transactions are not yet supported in MongoDB");
    }

    public <U, T extends Subscribable<U>> T execute(Function<DbExecute, T> executor) {
        return (T)((Subscribable)executor.apply(new MongoDbExecute(this.db, this.clientContext)));
    }

    public Single<Void> ping() {
        return this.execute(exec -> exec.get("{\"operation\":\"command\",\"query\":{ping:1}}", new Object[0])).flatMapSingle(it -> Single.empty());
    }

    public String dbType() {
        return "mongoDb";
    }

    private MongoClient initMongoClient() {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder().applyConnectionString(this.connectionString);
        if (this.config.username() != null || this.config.password() != null) {
            String credDb = this.config.credDb() == null ? this.connectionString.getDatabase() : this.config.credDb();
            MongoCredential credentials = MongoCredential.createCredential((String)this.config.username(), (String)credDb, (char[])this.config.password().toCharArray());
            settingsBuilder.credential(credentials);
        }
        return MongoClients.create((MongoClientSettings)settingsBuilder.build());
    }

    private MongoDatabase initMongoDatabase() {
        return this.client.getDatabase(this.connectionString.getDatabase());
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"DbClient", "MongoDB"});
    }

    private static final class MongoSessionSubscriber
    implements Subscriber<ClientSession> {
        private final CompletableFuture<ClientSession> txFuture;
        private ClientSession tx;
        private Subscription subscription;

        MongoSessionSubscriber(CompletableFuture<ClientSession> txFuture) {
            this.txFuture = txFuture;
            this.tx = null;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(1L);
        }

        public void onNext(ClientSession session) {
            this.tx = session;
            this.subscription.cancel();
        }

        public void onError(Throwable t) {
            this.txFuture.completeExceptionally(t);
        }

        public void onComplete() {
            this.txFuture.complete(this.tx);
        }
    }
}

