/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbRows;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

final class MongoDbQueryExecutor {
    private static final Logger LOGGER = Logger.getLogger(MongoDbStatementQuery.class.getName());

    private MongoDbQueryExecutor() {
        throw new UnsupportedOperationException("Utility class MongoDbQueryExecutor instances are not allowed!");
    }

    static CompletionStage<DbRows<DbRow>> executeQuery(MongoDbStatement dbStatement, CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            queryFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        CompletionStage<MongoDbStatement.MongoStatement> mongoStmtFuture = dbContextFuture.thenApply(dbContext -> {
            MongoDbStatement.MongoStatement stmt = new MongoDbStatement.MongoStatement(DbStatementType.QUERY, MongoDbStatement.READER_FACTORY, dbStatement.build());
            if (stmt.getOperation() == MongoDbStatement.MongoOperation.QUERY) {
                return stmt;
            }
            throw new UnsupportedOperationException(String.format("Operation %s is not supported", stmt.getOperation().toString()));
        });
        return MongoDbQueryExecutor.executeQueryInMongoDB(dbStatement, mongoStmtFuture, statementFuture, queryFuture);
    }

    private static CompletionStage<DbRows<DbRow>> executeQueryInMongoDB(MongoDbStatement dbStatement, CompletionStage<MongoDbStatement.MongoStatement> stmtFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        return stmtFuture.thenApply(mongoStmt -> {
            FindPublisher publisher;
            MongoCollection mc = dbStatement.db().getCollection(mongoStmt.getCollection());
            Document query = mongoStmt.getQuery();
            Document projection = mongoStmt.getProjection();
            LOGGER.fine(() -> String.format("Query: %s, Projection: %s", query.toString(), projection != null ? projection : "N/A"));
            FindPublisher findPublisher = publisher = dbStatement.noTx() ? mc.find((Bson)query) : mc.find(dbStatement.txManager().tx(), (Bson)query);
            if (projection != null) {
                publisher = publisher.projection((Bson)projection);
            }
            return publisher;
        }).thenApply(mongoPublisher -> new MongoDbRows<DbRow>((FindPublisher<Document>)mongoPublisher, dbStatement, DbRow.class, statementFuture, queryFuture));
    }
}

