/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbResult;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementGeneric;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.mongodb.MongoDbCommandExecutor;
import io.helidon.dbclient.mongodb.MongoDbDMLExecutor;
import io.helidon.dbclient.mongodb.MongoDbQueryExecutor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class MongoDbStatementGeneric
extends MongoDbStatement<DbStatementGeneric, DbResult>
implements DbStatementGeneric {
    private static final Logger LOGGER = Logger.getLogger(MongoDbStatementGeneric.class.getName());
    private DbStatementType dbStatementType;
    private MongoDbStatement.MongoStatement statement;

    MongoDbStatementGeneric(DbStatementType dbStatementType, MongoDatabase db, String statementName, String statement, DbMapperManager dbMapperManager, MapperManager mapperManager, InterceptorSupport interceptors) {
        super(dbStatementType, db, statementName, statement, dbMapperManager, mapperManager, interceptors);
        this.dbStatementType = dbStatementType;
    }

    public CompletionStage<DbResult> execute() {
        this.statement = new MongoDbStatement.MongoStatement(this.dbStatementType, READER_FACTORY, this.build());
        switch (this.statement.getOperation()) {
            case QUERY: {
                this.dbStatementType = DbStatementType.QUERY;
                break;
            }
            case INSERT: {
                this.dbStatementType = DbStatementType.INSERT;
                break;
            }
            case UPDATE: {
                this.dbStatementType = DbStatementType.UPDATE;
                break;
            }
            case DELETE: {
                this.dbStatementType = DbStatementType.DELETE;
                break;
            }
            case COMMAND: {
                this.dbStatementType = DbStatementType.COMMAND;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected value for generic statement: %s", new Object[]{this.statement.getOperation()}));
            }
        }
        return super.execute();
    }

    protected CompletionStage<DbResult> doExecute(CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        switch (this.dbStatementType) {
            case QUERY: {
                return CompletableFuture.completedFuture(new MongoDbQueryResult(MongoDbQueryExecutor.executeQuery(this, dbContextFuture, statementFuture, queryFuture)));
            }
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return CompletableFuture.completedFuture(new MongoDbDmlResult(MongoDbDMLExecutor.executeDml(this, this.dbStatementType, this.statement, dbContextFuture, statementFuture, queryFuture)));
            }
            case COMMAND: {
                return CompletableFuture.completedFuture(new MongoDbQueryResult(MongoDbCommandExecutor.executeCommand(this, dbContextFuture, statementFuture, queryFuture)));
            }
        }
        throw new UnsupportedOperationException(String.format("Operation %s is not supported.", this.dbStatementType.name()));
    }

    private static final class MongoDbDmlResult
    extends MongoDbAbstractResult<Long> {
        private MongoDbDmlResult(CompletionStage<Long> dmlResultFuture) {
            super(dmlResultFuture);
        }

        public DbResult whenDml(Consumer<Long> consumer) {
            this.resultFuture().thenAccept(consumer);
            return this;
        }

        public DbResult whenRs(Consumer<DbRows<DbRow>> consumer) {
            throw new IllegalStateException("Statement is not query.");
        }

        public CompletionStage<Long> dmlFuture() {
            return this.resultFuture();
        }

        public CompletionStage<DbRows<DbRow>> rsFuture() {
            throw new IllegalStateException("Statement is not query.");
        }
    }

    private static final class MongoDbQueryResult
    extends MongoDbAbstractResult<DbRows<DbRow>> {
        private MongoDbQueryResult(CompletionStage<DbRows<DbRow>> dbRowsFuture) {
            super(dbRowsFuture);
        }

        public DbResult whenDml(Consumer<Long> consumer) {
            throw new IllegalStateException("Statement is not DML.");
        }

        public DbResult whenRs(Consumer<DbRows<DbRow>> consumer) {
            this.resultFuture().thenAccept(consumer);
            return this;
        }

        public CompletionStage<Long> dmlFuture() {
            throw new IllegalStateException("Statement is not DML.");
        }

        public CompletionStage<DbRows<DbRow>> rsFuture() {
            return this.resultFuture();
        }
    }

    private static abstract class MongoDbAbstractResult<T>
    implements DbResult {
        private final CompletionStage<T> resultFuture;
        private final CompletableFuture<Throwable> throwableFuture;

        private MongoDbAbstractResult(CompletionStage<T> resultFuture) {
            this.resultFuture = resultFuture;
            this.throwableFuture = new CompletableFuture();
            resultFuture.exceptionally((Throwable throwable) -> {
                this.throwableFuture.complete((Throwable)throwable);
                return null;
            });
        }

        public DbResult exceptionally(Consumer<Throwable> exceptionHandler) {
            this.resultFuture.exceptionally((Throwable throwable) -> {
                exceptionHandler.accept((Throwable)throwable);
                return null;
            });
            return this;
        }

        public CompletionStage<Throwable> exceptionFuture() {
            return this.throwableFuture;
        }

        CompletionStage<T> resultFuture() {
            return this.resultFuture;
        }
    }
}

