/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.FindPublisher;
import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.reactive.MappingProcessor;
import io.helidon.common.reactive.Multi;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.mongodb.MongoDbQueryProcessor;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.bson.Document;
import org.reactivestreams.Subscriber;

public final class MongoDbRows<T>
implements DbRows<T> {
    private final AtomicBoolean resultRequested = new AtomicBoolean();
    private final FindPublisher<Document> documentFindPublisher;
    private final MongoDbStatement dbStatement;
    private final CompletableFuture<Long> queryFuture;
    private final GenericType<T> currentType;
    private final Function<?, T> resultMapper;
    private final MongoDbRows<?> parent;
    private final CompletableFuture<Void> statementFuture;

    MongoDbRows(FindPublisher<Document> documentFindPublisher, MongoDbStatement dbStatement, Class<T> initialType, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.documentFindPublisher = documentFindPublisher;
        this.dbStatement = dbStatement;
        this.statementFuture = statementFuture;
        this.queryFuture = queryFuture;
        this.currentType = GenericType.create(initialType);
        this.resultMapper = Function.identity();
        this.parent = null;
    }

    private MongoDbRows(FindPublisher<Document> documentFindPublisher, MongoDbStatement dbStatement, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture, GenericType<T> nextType, Function<?, T> resultMapper, MongoDbRows<?> parent) {
        this.documentFindPublisher = documentFindPublisher;
        this.dbStatement = dbStatement;
        this.statementFuture = statementFuture;
        this.queryFuture = queryFuture;
        this.resultMapper = resultMapper;
        this.currentType = nextType;
        this.parent = parent;
    }

    public <U> DbRows<U> map(Function<T, U> mapper) {
        return new MongoDbRows<U>(this.documentFindPublisher, this.dbStatement, this.statementFuture, this.queryFuture, null, mapper, this);
    }

    public <U> DbRows<U> map(Class<U> type) {
        return this.map(GenericType.create(type));
    }

    public <U> DbRows<U> map(GenericType<U> type) {
        Function<Object, Object> theMapper;
        GenericType<T> localCurrentType = this.currentType;
        if (null == localCurrentType) {
            theMapper = value -> this.dbStatement.mapperManager().map(value, GenericType.create(value.getClass()), type);
        } else if (localCurrentType.equals((Object)DbMapperManager.TYPE_DB_ROW)) {
            if (type.equals((Object)DbMapperManager.TYPE_DB_ROW)) {
                return this;
            }
            theMapper = value -> {
                try {
                    return this.dbStatement.dbMapperManager().read((DbRow)value, type);
                }
                catch (MapperException originalException) {
                    try {
                        return this.dbStatement.mapperManager().map((Object)((DbRow)value), DbMapperManager.TYPE_DB_ROW, type);
                    }
                    catch (MapperException ignored) {
                        throw originalException;
                    }
                }
            };
        } else {
            theMapper = value -> this.dbStatement.mapperManager().map(value, localCurrentType, type);
        }
        return new MongoDbRows<Object>(this.documentFindPublisher, this.dbStatement, this.statementFuture, this.queryFuture, type, theMapper, this);
    }

    public Flow.Publisher<T> publisher() {
        this.checkResult();
        return this.toPublisher();
    }

    private Flow.Publisher<T> toPublisher() {
        if (null == this.parent) {
            return this.toDbPublisher();
        }
        Flow.Publisher<?> parentPublisher = this.parent.publisher();
        Function<?, T> mappingFunction = this.resultMapper;
        MappingProcessor processor = MappingProcessor.create(mappingFunction);
        parentPublisher.subscribe((Flow.Subscriber<?>)processor);
        return processor;
    }

    public CompletionStage<List<T>> collect() {
        this.checkResult();
        return Multi.from(this.toPublisher()).collectList().toStage();
    }

    private Flow.Publisher<DbRow> toDbPublisher() {
        MongoDbQueryProcessor qp = new MongoDbQueryProcessor(this.dbStatement, this.statementFuture, this.queryFuture);
        this.documentFindPublisher.subscribe((Subscriber)qp);
        return qp;
    }

    private void checkResult() {
        if (this.resultRequested.get()) {
            throw new IllegalStateException("Result has already been requested");
        }
        this.resultRequested.set(true);
    }
}

