/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.Success;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class MongoDbDMLExecutor {
    private static final Logger LOGGER = Logger.getLogger(MongoDbDMLExecutor.class.getName());

    private MongoDbDMLExecutor() {
        throw new UnsupportedOperationException("Utility class MongoDbDMLExecutor instances are not allowed!");
    }

    static CompletionStage<Long> executeDml(MongoDbStatement dbStatement, DbStatementType dbStatementType, MongoDbStatement.MongoStatement mongoStatement, CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            queryFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        return dbContextFuture.thenCompose(dbContext -> {
            switch (dbStatementType) {
                case INSERT: {
                    return MongoDbDMLExecutor.executeInsert(dbStatement, dbStatementType, mongoStatement, statementFuture, queryFuture);
                }
                case UPDATE: {
                    return MongoDbDMLExecutor.executeUpdate(dbStatement, dbStatementType, mongoStatement, statementFuture, queryFuture);
                }
                case DELETE: {
                    return MongoDbDMLExecutor.executeDelete(dbStatement, dbStatementType, mongoStatement, statementFuture, queryFuture);
                }
            }
            CompletableFuture result = new CompletableFuture();
            UnsupportedOperationException failure = new UnsupportedOperationException(String.format("Statement operation not yet supported: %s", dbStatementType.name()));
            result.completeExceptionally(failure);
            statementFuture.completeExceptionally(failure);
            queryFuture.completeExceptionally(failure);
            return result;
        });
    }

    private static CompletionStage<Long> executeInsert(MongoDbStatement dbStatement, DbStatementType dbStatementType, MongoDbStatement.MongoStatement mongoStatement, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        MongoCollection mc = dbStatement.db().getCollection(mongoStatement.getCollection());
        Publisher insertPublisher = dbStatement.noTx() ? mc.insertOne((Object)mongoStatement.getValue()) : mc.insertOne(dbStatement.txManager().tx(), (Object)mongoStatement.getValue());
        insertPublisher.subscribe((Subscriber)new InsertResultSubscriber(dbStatement, dbStatementType, queryFuture, statementFuture));
        return queryFuture;
    }

    private static CompletionStage<Long> executeUpdate(MongoDbStatement dbStatement, DbStatementType dbStatementType, MongoDbStatement.MongoStatement mongoStatement, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        MongoCollection mc = dbStatement.db().getCollection(mongoStatement.getCollection());
        Document query = mongoStatement.getQuery();
        Publisher updatePublisher = dbStatement.noTx() ? mc.updateMany((Bson)query, (Bson)mongoStatement.getValue()) : mc.updateMany(dbStatement.txManager().tx(), (Bson)query, (Bson)mongoStatement.getValue());
        updatePublisher.subscribe((Subscriber)new UpdateResultSubscriber(dbStatement, dbStatementType, queryFuture, statementFuture));
        return queryFuture;
    }

    private static CompletionStage<Long> executeDelete(MongoDbStatement dbStatement, DbStatementType dbStatementType, MongoDbStatement.MongoStatement mongoStatement, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        MongoCollection mc = dbStatement.db().getCollection(mongoStatement.getCollection());
        Document query = mongoStatement.getQuery();
        Publisher deletePublisher = dbStatement.noTx() ? mc.deleteMany((Bson)query) : mc.deleteMany(dbStatement.txManager().tx(), (Bson)query);
        deletePublisher.subscribe((Subscriber)new DeleteResultSubscriber(dbStatement, dbStatementType, queryFuture, statementFuture));
        return queryFuture;
    }

    private static final class DeleteResultSubscriber
    extends DmlResultSubscriber<DeleteResult> {
        private DeleteResultSubscriber(MongoDbStatement dbStatement, DbStatementType dbStatementType, CompletableFuture<Long> queryFuture, CompletableFuture<Void> statementFuture) {
            super(dbStatement, dbStatementType, queryFuture, statementFuture);
        }

        public void onNext(DeleteResult r) {
            this.count().add(r.getDeletedCount());
        }
    }

    private static final class UpdateResultSubscriber
    extends DmlResultSubscriber<UpdateResult> {
        private UpdateResultSubscriber(MongoDbStatement dbStatement, DbStatementType dbStatementType, CompletableFuture<Long> queryFuture, CompletableFuture<Void> statementFuture) {
            super(dbStatement, dbStatementType, queryFuture, statementFuture);
        }

        public void onNext(UpdateResult r) {
            this.count().add(r.getModifiedCount());
        }
    }

    private static final class InsertResultSubscriber
    extends DmlResultSubscriber<Success> {
        private InsertResultSubscriber(MongoDbStatement dbStatement, DbStatementType dbStatementType, CompletableFuture<Long> queryFuture, CompletableFuture<Void> statementFuture) {
            super(dbStatement, dbStatementType, queryFuture, statementFuture);
        }

        public void onNext(Success r) {
            this.count().increment();
        }
    }

    private static abstract class DmlResultSubscriber<T>
    implements Subscriber<T> {
        private final MongoDbStatement dbStatement;
        private final DbStatementType dbStatementType;
        private final CompletableFuture<Void> statementFuture;
        private final CompletableFuture<Long> queryFuture;
        private final LongAdder count;

        private DmlResultSubscriber(MongoDbStatement dbStatement, DbStatementType dbStatementType, CompletableFuture<Long> queryFuture, CompletableFuture<Void> statementFuture) {
            this.dbStatement = dbStatement;
            this.dbStatementType = dbStatementType;
            this.statementFuture = statementFuture;
            this.queryFuture = queryFuture;
            this.count = new LongAdder();
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onError(Throwable t) {
            this.statementFuture.completeExceptionally(t);
            this.queryFuture.completeExceptionally(t);
            if (this.dbStatement.txManager() != null) {
                this.dbStatement.txManager().stmtFailed(this.dbStatement);
            }
            LOGGER.fine(() -> String.format("%s DML %s execution failed", this.dbStatementType.name(), this.dbStatement.statementName()));
        }

        public void onComplete() {
            this.statementFuture.complete(null);
            this.queryFuture.complete(this.count.sum());
            if (this.dbStatement.txManager() != null) {
                this.dbStatement.txManager().stmtFinished(this.dbStatement);
            }
            LOGGER.fine(() -> String.format("%s DML %s execution succeeded", this.dbStatementType.name(), this.dbStatement.statementName()));
        }

        LongAdder count() {
            return this.count;
        }
    }
}

