/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbColumn;
import io.helidon.dbclient.DbMapperManager;

public final class MongoDbColumn
implements DbColumn {
    private final MapperManager mapperManager;
    private final String name;
    private final Object value;

    MongoDbColumn(DbMapperManager dbMapperManager, MapperManager mapperManager, String name, Object value) {
        this.mapperManager = mapperManager;
        this.name = name;
        this.value = value;
    }

    public <T> T as(Class<T> type) throws MapperException {
        if (type.equals(this.javaType())) {
            return (T)this.value;
        }
        return this.map(this.value, type);
    }

    public <T> T as(GenericType<T> type) throws MapperException {
        return this.map(this.value, type);
    }

    private <S, T> T map(S value, Class<T> targetType) {
        Class<?> sourceType = this.javaType();
        return (T)this.mapperManager.map(value, sourceType, targetType);
    }

    private <S, T> T map(S value, GenericType<T> targetType) {
        Class<?> sourceClass = this.javaType();
        GenericType sourceType = GenericType.create(sourceClass);
        return (T)this.mapperManager.map(value, sourceType, targetType);
    }

    public Class<?> javaType() {
        return null == this.value ? String.class : this.value.getClass();
    }

    public String dbType() {
        throw new UnsupportedOperationException("dbType() is not supported yet.");
    }

    public String name() {
        return this.name;
    }
}

