/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementException;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcRow;
import io.helidon.dbclient.jdbc.JdbcStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

class JdbcStatementGet
extends JdbcStatement<DbStatementGet>
implements DbStatementGet {
    JdbcStatementGet(JdbcConnectionPool connectionPool, JdbcExecuteContext context) {
        super(connectionPool, context);
    }

    public DbStatementType statementType() {
        return DbStatementType.GET;
    }

    public Optional<DbRow> execute() {
        return (Optional)this.doExecute((future, context) -> {
            try {
                Optional<DbRow> optional = JdbcStatementGet.doExecute(this, future, context);
                return optional;
            }
            finally {
                this.closeConnection();
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Optional<DbRow> doExecute(JdbcStatement<? extends DbStatementGet> dbStmt, CompletableFuture<Long> future, DbClientServiceContext context) {
        try (PreparedStatement statement = dbStmt.prepareStatement(context);){
            Optional<DbRow> optional;
            block18: {
                ResultSet rs;
                block16: {
                    Optional<JdbcRow> optional2;
                    block17: {
                        rs = statement.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            Optional<JdbcRow> result = Optional.of(JdbcRow.create(rs, (DbContext)dbStmt.context()));
                            future.complete(1L);
                            optional2 = result;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                future.complete(0L);
                optional = Optional.empty();
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new DbStatementException("Failed to execute Statement", dbStmt.context().statement(), (Throwable)ex);
        }
    }
}

