/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbColumnBase;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRowBase;
import io.helidon.dbclient.DbStatementException;
import io.helidon.dbclient.jdbc.JdbcColumn;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

class JdbcRow
extends DbRowBase {
    private JdbcRow(JdbcColumn[] columns, DbMapperManager dbMapperManager) {
        super((DbColumnBase[])columns, dbMapperManager);
    }

    static JdbcRow create(ResultSet rs, DbContext context) throws SQLException {
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        JdbcColumn.MetaData[] metaData = new JdbcColumn.MetaData[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            metaData[i] = JdbcColumn.MetaData.create(rsMetaData, i + 1);
        }
        JdbcColumn[] columns = new JdbcColumn[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columns[i] = JdbcColumn.create(rs, metaData[i], context.mapperManager(), i + 1);
        }
        return new JdbcRow(columns, context.dbMapperManager());
    }

    static final class Spliterator
    extends Spliterators.AbstractSpliterator<DbRow> {
        private final ResultSet rs;
        private final Statement statement;
        private final DbExecuteContext context;
        private final CompletableFuture<Long> queryFuture;
        private long count;

        Spliterator(ResultSet rs, Statement statement, DbExecuteContext context, CompletableFuture<Long> queryFuture) {
            super(Long.MAX_VALUE, 16);
            this.rs = rs;
            this.context = context;
            this.statement = statement;
            this.queryFuture = queryFuture;
            this.count = 0L;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DbRow> action) {
            try {
                if (this.rs.next()) {
                    action.accept((DbRow)JdbcRow.create(this.rs, (DbContext)this.context));
                    ++this.count;
                    return true;
                }
                return false;
            }
            catch (SQLException ex) {
                throw new DbStatementException("Failed to retrieve next row from ResultSet", this.context.statement(), (Throwable)ex);
            }
        }

        void close() {
            try {
                this.queryFuture.complete(this.count);
                this.rs.close();
            }
            catch (SQLException ex) {
                throw new DbStatementException("Failed to close ResultSet", this.context.statement(), (Throwable)ex);
            }
            finally {
                this.closeStatement();
            }
        }

        private void closeStatement() {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                throw new DbStatementException("Failed to close Statement", this.context.statement(), (Throwable)ex);
            }
        }
    }
}

