/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

class NamedStatementParser {
    private static final Action[][] ACTION = new Action[][]{{NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::doNothing, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar}, {NamedStatementParser::setFirstParamChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColonAndCopyChar, NamedStatementParser::addColon, NamedStatementParser::addColonAndCopyChar}, {NamedStatementParser::setNextParamChar, NamedStatementParser::setNextParamChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParamAndCopyChar, NamedStatementParser::finishParam, NamedStatementParser::finishParamAndCopyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::doNothing, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::doNothing, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar}, {NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar, NamedStatementParser::copyChar}};
    private final String statement;
    private final StringBuilder sb;
    private final StringBuilder nap;
    private final List<String> names;
    private char c;
    private CharClass cl;

    private static void doNothing(NamedStatementParser parser) {
    }

    private static void copyChar(NamedStatementParser parser) {
        parser.sb.append(parser.c);
    }

    private static void addColon(NamedStatementParser parser) {
        parser.sb.append(':');
    }

    private static void addColonAndCopyChar(NamedStatementParser parser) {
        parser.sb.append(':');
        parser.sb.append(parser.c);
    }

    private static void setFirstParamChar(NamedStatementParser parser) {
        parser.nap.setLength(0);
        parser.nap.append(parser.c);
    }

    private static void setNextParamChar(NamedStatementParser parser) {
        parser.nap.append(parser.c);
    }

    private static void finishParamAndCopyChar(NamedStatementParser parser) {
        String parName = parser.nap.toString();
        parser.names.add(parName);
        parser.sb.append('?');
        parser.sb.append(parser.c);
    }

    private static void finishParam(NamedStatementParser parser) {
        String parName = parser.nap.toString();
        parser.names.add(parName);
        parser.sb.append('?');
    }

    NamedStatementParser(String statement) {
        this.sb = new StringBuilder(statement.length());
        this.nap = new StringBuilder(32);
        this.names = new LinkedList<String>();
        this.statement = statement;
        this.c = '\u0000';
        this.cl = null;
    }

    String convert() {
        State state = State.STATEMENT;
        int len = this.statement.length();
        for (int i = 0; i < len; ++i) {
            this.c = this.statement.charAt(i);
            this.cl = CharClass.charClass(this.c);
            ACTION[state.ordinal()][this.cl.ordinal()].accept(this);
            state = State.TRANSITION[state.ordinal()][this.cl.ordinal()];
        }
        if (state == State.PARAMETER) {
            String parName = this.nap.toString();
            this.names.add(parName);
            this.sb.append('?');
        }
        return this.sb.toString();
    }

    List<String> namesOrder() {
        return this.names;
    }

    private static enum CharClass {
        IDENTIFIER_START,
        IDENTIFIER_PART,
        LF,
        CR,
        APOSTROPHE,
        STAR,
        DASH,
        SLASH,
        COLON,
        OTHER;


        private static CharClass charClass(char c) {
            switch (c) {
                case '\r': {
                    return CR;
                }
                case '\n': {
                    return LF;
                }
                case '\'': {
                    return APOSTROPHE;
                }
                case '*': {
                    return STAR;
                }
                case '-': {
                    return DASH;
                }
                case '/': {
                    return SLASH;
                }
                case ':': {
                    return COLON;
                }
                case '_': {
                    return IDENTIFIER_START;
                }
            }
            return Character.isJavaIdentifierStart(c) ? IDENTIFIER_START : (Character.isJavaIdentifierPart(c) ? IDENTIFIER_PART : OTHER);
        }
    }

    private static enum State {
        STATEMENT,
        STRING,
        COLON,
        PARAMETER,
        MULTILN_COMMENT_BG,
        MULTILN_COMMENT_END,
        MULTILN_COMMENT,
        SINGLELN_COMMENT_BG,
        SINGLELN_COMMENT_END,
        SINGLELN_COMMENT;

        private static final State[][] TRANSITION;

        static {
            TRANSITION = new State[][]{{STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {STRING, STRING, STRING, STRING, STATEMENT, STRING, STRING, STRING, STRING, STRING}, {PARAMETER, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {PARAMETER, PARAMETER, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, MULTILN_COMMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT_END, MULTILN_COMMENT, STATEMENT, MULTILN_COMMENT, MULTILN_COMMENT}, {MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT_END, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT}, {STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT, MULTILN_COMMENT_BG, COLON, STATEMENT}, {SINGLELN_COMMENT, SINGLELN_COMMENT, STATEMENT, SINGLELN_COMMENT_END, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT}, {SINGLELN_COMMENT, SINGLELN_COMMENT, STATEMENT, SINGLELN_COMMENT_END, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT}};
        }
    }

    @FunctionalInterface
    private static interface Action
    extends Consumer<NamedStatementParser> {
    }
}

