/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientBase;
import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.jdbc.CloseableJdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcClientBuilder;
import io.helidon.dbclient.jdbc.JdbcClientContext;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecute;
import io.helidon.dbclient.jdbc.JdbcTransaction;
import java.sql.Connection;

class JdbcClient
extends DbClientBase
implements DbClient {
    private static final System.Logger LOGGER = System.getLogger(JdbcClient.class.getName());
    private final JdbcConnectionPool connectionPool;

    JdbcClient(JdbcClientBuilder builder) {
        super((DbClientContext)((JdbcClientContext.Builder)((JdbcClientContext.Builder)((JdbcClientContext.Builder)((JdbcClientContext.Builder)((JdbcClientContext.Builder)((JdbcClientContext.Builder)JdbcClientContext.jdbcBuilder().missingMapParametersAsNull(builder.missingMapParametersAsNull())).statements(builder.statements())).dbMapperManager(builder.dbMapperManager())).mapperManager(builder.mapperManager())).clientServices(builder.clientServices())).dbType(builder.connectionPool().dbType())).parametersSetter(builder.parametersConfig()).build());
        this.connectionPool = builder.connectionPool();
    }

    public JdbcExecute execute() {
        return new JdbcExecute(this.context(), this.connectionPool);
    }

    public JdbcTransaction transaction() {
        return new JdbcTransaction(this.context(), this.connectionPool);
    }

    public String dbType() {
        return this.connectionPool.dbType();
    }

    public JdbcClientContext context() {
        return (JdbcClientContext)super.context();
    }

    public void close() {
        JdbcConnectionPool jdbcConnectionPool = this.connectionPool;
        if (jdbcConnectionPool instanceof CloseableJdbcConnectionPool) {
            CloseableJdbcConnectionPool cjcp = (CloseableJdbcConnectionPool)jdbcConnectionPool;
            try {
                cjcp.close();
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.WARNING, "Failed to close the connection pool", (Throwable)e);
            }
        }
    }

    public <C> C unwrap(Class<C> cls) {
        if (Connection.class.isAssignableFrom(cls)) {
            return cls.cast(this.connectionPool.connection());
        }
        if (JdbcClient.class.isAssignableFrom(cls) || DbClientBase.class.isAssignableFrom(cls)) {
            return cls.cast((Object)this);
        }
        throw new UnsupportedOperationException(String.format("Class %s is not supported for unwrap", cls.getName()));
    }
}

