/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;

class TransactionContext {
    private static final System.Logger LOGGER = System.getLogger(TransactionContext.class.getName());
    private Connection connection = null;
    private State state = State.INIT;
    private final Supplier<Connection> connectionFactory;

    TransactionContext(Supplier<Connection> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    Connection connection() {
        switch (this.state.ordinal()) {
            case 0: {
                this.connection = this.connectionFactory.get();
                this.state = State.ACTIVE;
                return this.connection;
            }
            case 1: {
                return this.connection;
            }
            case 2: {
                throw new IllegalStateException("Transaction was already committed");
            }
            case 3: {
                throw new IllegalStateException("Transaction was already rolled back");
            }
        }
        throw new IllegalStateException("Unknown transaction state");
    }

    void commit() throws SQLException {
        switch (this.state.ordinal()) {
            case 0: {
                this.state = State.COMMIT;
                LOGGER.log(System.Logger.Level.WARNING, "Transaction commit with no statement being executed.");
                break;
            }
            case 1: {
                this.state = State.COMMIT;
                try {
                    this.connection.commit();
                    break;
                }
                finally {
                    this.connection.close();
                }
            }
            case 2: {
                throw new IllegalStateException("Transaction was already committed");
            }
            case 3: {
                throw new IllegalStateException("Transaction was already rolled back");
            }
            default: {
                throw new IllegalStateException("Unknown transaction state");
            }
        }
    }

    void rollback() throws SQLException {
        switch (this.state.ordinal()) {
            case 0: {
                this.state = State.ROLLBACK;
                LOGGER.log(System.Logger.Level.WARNING, "Transaction rollback with no statement being executed.");
                break;
            }
            case 1: {
                this.state = State.ROLLBACK;
                try {
                    this.connection.rollback();
                    break;
                }
                finally {
                    this.connection.close();
                }
            }
            case 2: {
                throw new IllegalStateException("Transaction was already committed");
            }
            case 3: {
                throw new IllegalStateException("Transaction was already rolled back");
            }
            default: {
                throw new IllegalStateException("Unknown transaction state");
            }
        }
    }

    private static enum State {
        INIT,
        ACTIVE,
        COMMIT,
        ROLLBACK;

    }
}

