/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbStatement;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import io.helidon.dbclient.jdbc.TransactionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

abstract class JdbcTransactionStatement<S extends DbStatement<S>>
extends JdbcStatement<S> {
    private final TransactionContext transactionContext;

    protected JdbcTransactionStatement(JdbcConnectionPool connectionPool, JdbcExecuteContext context, TransactionContext transactionContext) {
        super(connectionPool, context);
        this.transactionContext = transactionContext;
    }

    @Override
    protected PreparedStatement prepareStatement(String stmtName, String stmt) {
        Connection connection = this.transactionContext.connection();
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DbClientException("Failed to set autocommit to false", (Throwable)e);
        }
        return this.prepareStatement(connection, stmtName, stmt);
    }
}

