/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.dbclient.jdbc.JdbcParametersConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.dbclient.jdbc.JdbcParametersConfigBlueprint")
public interface JdbcParametersConfig
extends JdbcParametersConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JdbcParametersConfig instance) {
        return (Builder)JdbcParametersConfig.builder().from(instance);
    }

    public static JdbcParametersConfig create(Config config) {
        return ((Builder)JdbcParametersConfig.builder().config(config)).buildPrototype();
    }

    public static JdbcParametersConfig create() {
        return JdbcParametersConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, JdbcParametersConfig>
    implements io.helidon.common.Builder<Builder, JdbcParametersConfig> {
        private Builder() {
        }

        public JdbcParametersConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JdbcParametersConfigImpl(this);
        }

        public JdbcParametersConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JdbcParametersConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean setObjectForJavaTime = true;
        private boolean timestampForLocalTime = true;
        private boolean useByteArrayBinding = true;
        private boolean useNString = false;
        private boolean useStringBinding = true;
        private Config config;
        private int stringBindingSize = 1024;

        protected BuilderBase() {
        }

        public BUILDER from(JdbcParametersConfig prototype) {
            this.useNString(prototype.useNString());
            this.useStringBinding(prototype.useStringBinding());
            this.stringBindingSize(prototype.stringBindingSize());
            this.useByteArrayBinding(prototype.useByteArrayBinding());
            this.timestampForLocalTime(prototype.timestampForLocalTime());
            this.setObjectForJavaTime(prototype.setObjectForJavaTime());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.useNString(builder.useNString());
            this.useStringBinding(builder.useStringBinding());
            this.stringBindingSize(builder.stringBindingSize());
            this.useByteArrayBinding(builder.useByteArrayBinding());
            this.timestampForLocalTime(builder.timestampForLocalTime());
            this.setObjectForJavaTime(builder.setObjectForJavaTime());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("use-n-string").as(Boolean.class).ifPresent(this::useNString);
            config.get("use-string-binding").as(Boolean.class).ifPresent(this::useStringBinding);
            config.get("string-binding-size").as(Integer.class).ifPresent(this::stringBindingSize);
            config.get("use-byte-array-binding").as(Boolean.class).ifPresent(this::useByteArrayBinding);
            config.get("timestamp-for-local-time").as(Boolean.class).ifPresent(this::timestampForLocalTime);
            config.get("set-object-for-java-time").as(Boolean.class).ifPresent(this::setObjectForJavaTime);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useNString(boolean useNString) {
            this.useNString = useNString;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useStringBinding(boolean useStringBinding) {
            this.useStringBinding = useStringBinding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER stringBindingSize(int stringBindingSize) {
            this.stringBindingSize = stringBindingSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER useByteArrayBinding(boolean useByteArrayBinding) {
            this.useByteArrayBinding = useByteArrayBinding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timestampForLocalTime(boolean timestampForLocalTime) {
            this.timestampForLocalTime = timestampForLocalTime;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER setObjectForJavaTime(boolean setObjectForJavaTime) {
            this.setObjectForJavaTime = setObjectForJavaTime;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean useNString() {
            return this.useNString;
        }

        public boolean useStringBinding() {
            return this.useStringBinding;
        }

        public int stringBindingSize() {
            return this.stringBindingSize;
        }

        public boolean useByteArrayBinding() {
            return this.useByteArrayBinding;
        }

        public boolean timestampForLocalTime() {
            return this.timestampForLocalTime;
        }

        public boolean setObjectForJavaTime() {
            return this.setObjectForJavaTime;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "JdbcParametersConfigBuilder{useNString=" + this.useNString + ",useStringBinding=" + this.useStringBinding + ",stringBindingSize=" + this.stringBindingSize + ",useByteArrayBinding=" + this.useByteArrayBinding + ",timestampForLocalTime=" + this.timestampForLocalTime + ",setObjectForJavaTime=" + this.setObjectForJavaTime + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class JdbcParametersConfigImpl
        implements JdbcParametersConfig {
            private final boolean setObjectForJavaTime;
            private final boolean timestampForLocalTime;
            private final boolean useByteArrayBinding;
            private final boolean useNString;
            private final boolean useStringBinding;
            private final int stringBindingSize;

            protected JdbcParametersConfigImpl(BuilderBase<?, ?> builder) {
                this.useNString = builder.useNString();
                this.useStringBinding = builder.useStringBinding();
                this.stringBindingSize = builder.stringBindingSize();
                this.useByteArrayBinding = builder.useByteArrayBinding();
                this.timestampForLocalTime = builder.timestampForLocalTime();
                this.setObjectForJavaTime = builder.setObjectForJavaTime();
            }

            @Override
            public boolean useNString() {
                return this.useNString;
            }

            @Override
            public boolean useStringBinding() {
                return this.useStringBinding;
            }

            @Override
            public int stringBindingSize() {
                return this.stringBindingSize;
            }

            @Override
            public boolean useByteArrayBinding() {
                return this.useByteArrayBinding;
            }

            @Override
            public boolean timestampForLocalTime() {
                return this.timestampForLocalTime;
            }

            @Override
            public boolean setObjectForJavaTime() {
                return this.setObjectForJavaTime;
            }

            public String toString() {
                return "JdbcParametersConfig{useNString=" + this.useNString + ",useStringBinding=" + this.useStringBinding + ",stringBindingSize=" + this.stringBindingSize + ",useByteArrayBinding=" + this.useByteArrayBinding + ",timestampForLocalTime=" + this.timestampForLocalTime + ",setObjectForJavaTime=" + this.setObjectForJavaTime + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JdbcParametersConfig)) {
                    return false;
                }
                JdbcParametersConfig other = (JdbcParametersConfig)o;
                return this.useNString == other.useNString() && this.useStringBinding == other.useStringBinding() && this.stringBindingSize == other.stringBindingSize() && this.useByteArrayBinding == other.useByteArrayBinding() && this.timestampForLocalTime == other.timestampForLocalTime() && this.setObjectForJavaTime == other.setObjectForJavaTime();
            }

            public int hashCode() {
                return Objects.hash(this.useNString, this.useStringBinding, this.stringBindingSize, this.useByteArrayBinding, this.timestampForLocalTime, this.setObjectForJavaTime);
            }
        }
    }
}

