/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.context.Context;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbStatementType;
import java.util.concurrent.CompletionStage;

abstract class JdbcClientServiceContext
implements DbClientServiceContext {
    private final DbExecuteContext execContext;
    private final DbStatementType stmtType;
    private final CompletionStage<Void> stmtFuture;
    private final CompletionStage<Long> queryFuture;
    private Context context;
    private String statementName;

    JdbcClientServiceContext(Context context, DbExecuteContext execContext, DbStatementType stmtType, CompletionStage<Void> stmtFuture, CompletionStage<Long> queryFuture) {
        this.context = context;
        this.execContext = execContext;
        this.stmtType = stmtType;
        this.stmtFuture = stmtFuture;
        this.queryFuture = queryFuture;
        this.statementName = execContext.statementName();
    }

    public Context context() {
        return this.context;
    }

    public DbExecuteContext execContext() {
        return this.execContext;
    }

    public String statement() {
        return this.execContext.statement();
    }

    public String statementName() {
        return this.statementName;
    }

    public DbStatementType statementType() {
        return this.stmtType;
    }

    public String dbType() {
        return this.execContext.dbType();
    }

    public JdbcClientServiceContext context(Context context) {
        this.context = context;
        return this;
    }

    public JdbcClientServiceContext statementName(String name) {
        this.statementName = name;
        return this;
    }

    public CompletionStage<Void> statementFuture() {
        return this.stmtFuture;
    }

    public CompletionStage<Long> resultFuture() {
        return this.queryFuture;
    }
}

