/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.Builder;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.NamedService;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.jdbc.spi.JdbcConnectionPoolProvider;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;

@FunctionalInterface
public interface JdbcConnectionPool
extends NamedService {
    public static final String DEFAULT_DB_TYPE = "jdbc";

    public static JdbcConnectionPool create(Config config) {
        List poolProviders = HelidonServiceLoader.create(ServiceLoader.load(JdbcConnectionPoolProvider.class)).asList();
        if (poolProviders.isEmpty()) {
            throw new DbClientException("No JDBC connection pool provider is available");
        }
        return (JdbcConnectionPool)((JdbcConnectionPoolProvider)poolProviders.getFirst()).create(config, config.name());
    }

    public Connection connection();

    default public String dbType() {
        return DEFAULT_DB_TYPE;
    }

    default public String name() {
        return "inlined";
    }

    default public String type() {
        return "inlined";
    }

    public static abstract class BuilderBase<B extends BuilderBase<B, T>, T extends JdbcConnectionPool>
    implements Builder<B, T> {
        protected static final String URL = "url";
        protected static final String USERNAME = "username";
        protected static final String PASSWORD = "password";
        protected static final String HELIDON_RESERVED_CONFIG_KEY = "helidon";
        private Properties properties = new Properties();
        private String serviceName;
        private String url;
        private String username;
        private String password;

        protected BuilderBase() {
        }

        public B config(Config config) {
            Map poolConfig = (Map)config.detach().asMap().get();
            poolConfig.forEach((key, value) -> {
                switch (key) {
                    case "url": {
                        this.url((String)value);
                        break;
                    }
                    case "username": {
                        this.username((String)value);
                        break;
                    }
                    case "password": {
                        this.password((String)value);
                        break;
                    }
                    default: {
                        if (key.startsWith("helidon.")) break;
                        this.properties().setProperty((String)key, (String)value);
                    }
                }
            });
            return (B)((BuilderBase)this.identity());
        }

        public B url(String url) {
            this.url = url;
            return (B)((BuilderBase)this.identity());
        }

        public B username(String username) {
            this.username = username;
            return (B)((BuilderBase)this.identity());
        }

        public B password(String password) {
            this.password = password;
            return (B)((BuilderBase)this.identity());
        }

        public B properties(Properties properties) {
            this.properties = properties;
            return (B)((BuilderBase)this.identity());
        }

        public B serviceName(String serviceName) {
            this.serviceName = serviceName;
            return (B)((BuilderBase)this.identity());
        }

        public String serviceName() {
            return this.serviceName;
        }

        public String url() {
            return this.url;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public Properties properties() {
            return this.properties;
        }
    }
}

