/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.config.Config;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientBuilderBase;
import io.helidon.dbclient.jdbc.JdbcClient;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcParametersConfig;
import io.helidon.dbclient.jdbc.JdbcParametersConfigBlueprint;
import io.helidon.dbclient.spi.DbClientBuilder;

public final class JdbcClientBuilder
extends DbClientBuilderBase<JdbcClientBuilder>
implements DbClientBuilder<JdbcClientBuilder> {
    private JdbcConnectionPool connectionPool;
    private JdbcParametersConfigBlueprint parametersConfig = JdbcParametersConfig.create();

    JdbcClientBuilder() {
    }

    public static JdbcClientBuilder create() {
        return new JdbcClientBuilder();
    }

    public DbClient doBuild() {
        return new JdbcClient(this);
    }

    public JdbcClientBuilder config(Config config) {
        super.config(config);
        config.get("connection").detach().map(JdbcConnectionPool::create).ifPresent(this::connectionPool);
        Config parameters = config.get("parameters");
        if (parameters.exists()) {
            this.parametersConfig = JdbcParametersConfig.create(parameters);
        }
        return this;
    }

    public JdbcClientBuilder parametersSetter(JdbcParametersConfig parametersConfig) {
        this.parametersConfig = parametersConfig;
        return this;
    }

    public JdbcClientBuilder connectionPool(JdbcConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    JdbcConnectionPool connectionPool() {
        return this.connectionPool;
    }

    JdbcParametersConfigBlueprint parametersConfig() {
        return this.parametersConfig;
    }
}

