/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbColumn;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdbcStatementQuery
extends JdbcStatement<DbStatementQuery, Multi<DbRow>>
implements DbStatementQuery {
    private static final Logger LOGGER = Logger.getLogger(JdbcStatementQuery.class.getName());

    JdbcStatementQuery(JdbcExecuteContext executeContext, DbStatementContext statementContext) {
        super(executeContext, statementContext);
    }

    protected Multi<DbRow> doExecute(Single<DbClientServiceContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.executeContext().addFuture(queryFuture);
        return dbContextFuture.flatMap(dbContext -> this.doExecute((DbClientServiceContext)dbContext, statementFuture, queryFuture));
    }

    private Multi<DbRow> doExecute(DbClientServiceContext dbContext, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        return Single.create(this.connection()).flatMap(connection -> this.doExecute(dbContext, (Connection)connection, statementFuture, queryFuture));
    }

    private Multi<DbRow> doExecute(DbClientServiceContext dbContext, Connection connection, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        CompletableFuture result = new CompletableFuture();
        this.executorService().submit(() -> {
            PreparedStatement statement;
            try {
                statement = super.build(connection, dbContext);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
                statementFuture.completeExceptionally(e);
                queryFuture.completeExceptionally(e);
                return;
            }
            try {
                ResultSet rs = statement.executeQuery();
                statementFuture.complete(null);
                result.complete(JdbcStatementQuery.processResultSet(this.executorService(), this.dbMapperManager(), this.mapperManager(), queryFuture, rs));
            }
            catch (Throwable e) {
                LOGGER.log(Level.FINEST, String.format("Failed to execute query %s: %s", statement.toString(), e.getMessage()), e);
                result.completeExceptionally(e);
                statementFuture.completeExceptionally(e);
            }
        });
        return Single.create(result).flatMap(Function.identity());
    }

    static Multi<DbRow> processResultSet(ExecutorService executorService, DbMapperManager dbMapperManager, MapperManager mapperManager, CompletableFuture<Long> queryFuture, ResultSet resultSet) {
        return Multi.create(new JdbcDbRows(resultSet, executorService, dbMapperManager, mapperManager, queryFuture).publisher());
    }

    static Map<Long, DbColumn> createMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashMap<Long, DbColumn> byNumbers = new HashMap<Long, DbColumn>();
        for (int i = 1; i <= columnCount; ++i) {
            final String name = metaData.getColumnLabel(i);
            final String sqlType = metaData.getColumnTypeName(i);
            final Class<?> javaClass = JdbcStatementQuery.classByName(metaData.getColumnClassName(i));
            DbColumn column = new DbColumn(){

                public <T> T as(Class<T> type) {
                    return null;
                }

                public <T> T as(GenericType<T> type) {
                    return null;
                }

                public Class<?> javaType() {
                    return javaClass;
                }

                public String dbType() {
                    return sqlType;
                }

                public String name() {
                    return name;
                }
            };
            byNumbers.put(Long.valueOf(i), column);
        }
        return byNumbers;
    }

    private static Class<?> classByName(String columnClassName) {
        if (columnClassName == null) {
            return null;
        }
        try {
            return Class.forName(columnClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static final class JdbcDbRows {
        private final AtomicBoolean resultRequested = new AtomicBoolean();
        private final ExecutorService executorService;
        private final DbMapperManager dbMapperManager;
        private final MapperManager mapperManager;
        private final CompletableFuture<Long> queryFuture;
        private final ResultSet resultSet;

        private JdbcDbRows(ResultSet resultSet, ExecutorService executorService, DbMapperManager dbMapperManager, MapperManager mapperManager, CompletableFuture<Long> queryFuture) {
            this.executorService = executorService;
            this.dbMapperManager = dbMapperManager;
            this.mapperManager = mapperManager;
            this.queryFuture = queryFuture;
            this.resultSet = resultSet;
        }

        Flow.Publisher<DbRow> publisher() {
            this.checkResult();
            return this.toPublisher();
        }

        private Flow.Publisher<DbRow> toPublisher() {
            return new RowPublisher(this.executorService, this.resultSet, this.queryFuture, this.dbMapperManager, this.mapperManager);
        }

        private void checkResult() {
            if (this.resultRequested.get()) {
                throw new IllegalStateException("Result has already been requested");
            }
            this.resultRequested.set(true);
        }
    }

    static final class ResultWithConn {
        private final ResultSet resultSet;
        private final Connection connection;

        ResultWithConn(ResultSet resultSet, Connection connection) {
            this.resultSet = resultSet;
            this.connection = connection;
        }

        public ResultSet resultSet() {
            return this.resultSet;
        }

        public Connection connection() {
            return this.connection;
        }
    }

    private static final class RowPublisher
    implements Flow.Publisher<DbRow> {
        private final ExecutorService executorService;
        private final ResultSet rs;
        private final CompletableFuture<Long> queryFuture;
        private final DbMapperManager dbMapperManager;
        private final MapperManager mapperManager;

        private RowPublisher(ExecutorService executorService, ResultSet rs, CompletableFuture<Long> queryFuture, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            this.executorService = executorService;
            this.rs = rs;
            this.queryFuture = queryFuture;
            this.dbMapperManager = dbMapperManager;
            this.mapperManager = mapperManager;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super DbRow> subscriber) {
            final LinkedBlockingQueue requestQueue = new LinkedBlockingQueue();
            final AtomicBoolean cancelled = new AtomicBoolean();
            subscriber.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    requestQueue.add(n);
                }

                @Override
                public void cancel() {
                    cancelled.set(true);
                    requestQueue.clear();
                }
            });
            this.executorService.submit(() -> {
                try (ResultSet rs = this.rs;){
                    Map<Long, DbColumn> metadata = JdbcStatementQuery.createMetadata(rs);
                    long count = 0L;
                    while (!cancelled.get()) {
                        Long nextElement;
                        try {
                            nextElement = (Long)requestQueue.poll(10L, TimeUnit.MINUTES);
                        }
                        catch (InterruptedException e) {
                            LOGGER.finest("Interrupted while polling for requests, terminating DB read");
                            subscriber.onError(e);
                            break;
                        }
                        if (nextElement == null) {
                            LOGGER.finest("No data requested for 10 minutes, terminating DB read");
                            subscriber.onError(new TimeoutException("No data requested in 10 minutes"));
                            break;
                        }
                        for (long i = 0L; i < nextElement; ++i) {
                            if (rs.next()) {
                                DbRow dbRow = this.createDbRow(rs, metadata, this.dbMapperManager, this.mapperManager);
                                subscriber.onNext(dbRow);
                                ++count;
                                continue;
                            }
                            this.queryFuture.complete(count);
                            subscriber.onComplete();
                            return;
                        }
                    }
                    if (cancelled.get()) {
                        this.queryFuture.completeExceptionally(new CancellationException("Processing cancelled by subscriber"));
                    }
                }
                catch (SQLException e) {
                    this.queryFuture.completeExceptionally(e);
                    subscriber.onError(e);
                }
            });
        }

        private DbRow createDbRow(ResultSet rs, Map<Long, DbColumn> metadata, final DbMapperManager dbMapperManager, final MapperManager mapperManager) throws SQLException {
            final HashMap<String, 2> byStringsWithValues = new HashMap<String, 2>();
            final HashMap<Integer, 2> byNumbersWithValues = new HashMap<Integer, 2>();
            for (int i = 1; i <= metadata.size(); ++i) {
                final DbColumn meta = metadata.get(i);
                final Object value = rs.getObject(i);
                DbColumn withValue = new DbColumn(){

                    public <T> T as(Class<T> type) {
                        if (null == value) {
                            return null;
                        }
                        if (type.isAssignableFrom(value.getClass())) {
                            return type.cast(value);
                        }
                        return this.map(value, type);
                    }

                    <SRC, T> T map(SRC value2, Class<T> type) {
                        Class<?> theClass = value2.getClass();
                        try {
                            return (T)mapperManager.map(value2, theClass, type);
                        }
                        catch (MapperException e) {
                            if (type.equals(String.class)) {
                                return (T)String.valueOf(value2);
                            }
                            throw e;
                        }
                    }

                    <SRC, T> T map(SRC value2, GenericType<T> type) {
                        Class<?> theClass = value2.getClass();
                        return (T)mapperManager.map(value2, GenericType.create(theClass), type);
                    }

                    public <T> T as(GenericType<T> type) {
                        Class theClass;
                        if (null == value) {
                            return null;
                        }
                        if (type.isClass() && (theClass = type.rawType()).isAssignableFrom(value.getClass())) {
                            return (T)type.cast(value);
                        }
                        return this.map(value, type);
                    }

                    public Class<?> javaType() {
                        if (null == meta.javaType()) {
                            if (null == value) {
                                return null;
                            }
                            return value.getClass();
                        }
                        return meta.javaType();
                    }

                    public String dbType() {
                        return meta.dbType();
                    }

                    public String name() {
                        return meta.name();
                    }
                };
                byStringsWithValues.put(meta.name(), withValue);
                byNumbersWithValues.put(i, withValue);
            }
            return new DbRow(){

                public DbColumn column(String name) {
                    return (DbColumn)byStringsWithValues.get(name);
                }

                public DbColumn column(int index) {
                    return (DbColumn)byNumbersWithValues.get(index);
                }

                public void forEach(Consumer<? super DbColumn> columnAction) {
                    byStringsWithValues.values().forEach(columnAction);
                }

                public <T> T as(Class<T> type) {
                    return (T)dbMapperManager.read((DbRow)this, type);
                }

                public <T> T as(GenericType<T> type) {
                    return (T)dbMapperManager.read((DbRow)this, type);
                }

                public <T> T as(Function<DbRow, T> mapper) {
                    return mapper.apply(this);
                }

                public String toString() {
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    sb.append('{');
                    for (DbColumn col : byStringsWithValues.values()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(',');
                        }
                        sb.append(col.name());
                        sb.append(':');
                        sb.append(col.value().toString());
                    }
                    sb.append('}');
                    return sb.toString();
                }
            };
        }
    }
}

