/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.dbclient.jdbc.HikariConnectionPool;
import io.helidon.dbclient.jdbc.HikariCpExtension;
import io.helidon.dbclient.jdbc.spi.HikariCpExtensionProvider;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@FunctionalInterface
public interface ConnectionPool {
    public static ConnectionPool create(Config config) {
        return ConnectionPool.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Connection connection();

    default public String dbType() {
        return "jdbc";
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ConnectionPool> {
        static final String URL = "url";
        static final String USERNAME = "username";
        static final String PASSWORD = "password";
        static final String HELIDON_RESERVED_CONFIG_KEY = "helidon";
        private static final Pattern URL_PATTERN = Pattern.compile("(\\w+:\\w+):.*");
        private Properties properties = new Properties();
        private String url;
        private String username;
        private String password;
        private Config extensionsConfig;
        private final HelidonServiceLoader.Builder<HikariCpExtensionProvider> extensionLoader = HelidonServiceLoader.builder(ServiceLoader.load(HikariCpExtensionProvider.class));

        private Builder() {
        }

        public ConnectionPool build() {
            Matcher matcher = URL_PATTERN.matcher(this.url);
            String dbType = matcher.matches() ? matcher.group(1) : "jdbc";
            return new HikariConnectionPool(this, dbType, this.extensions());
        }

        private List<HikariCpExtension> extensions() {
            if (null == this.extensionsConfig) {
                this.extensionsConfig = Config.empty();
            }
            return this.extensionLoader.build().asList().stream().map(provider -> provider.extension(this.extensionsConfig.get(provider.configKey()))).collect(Collectors.toList());
        }

        public Builder config(Config config) {
            Map poolConfig = (Map)config.detach().asMap().get();
            poolConfig.forEach((key, value) -> {
                switch (key) {
                    case "url": {
                        this.url((String)value);
                        break;
                    }
                    case "username": {
                        this.username((String)value);
                        break;
                    }
                    case "password": {
                        this.password((String)value);
                        break;
                    }
                    default: {
                        if (key.startsWith("helidon.")) break;
                        this.properties.setProperty((String)key, (String)value);
                    }
                }
            });
            this.extensionsConfig = config.get(HELIDON_RESERVED_CONFIG_KEY);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        Properties properties() {
            return this.properties;
        }

        String url() {
            return this.url;
        }

        String username() {
            return this.username;
        }

        String password() {
            return this.password;
        }
    }
}

