/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbResult;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementGeneric;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import io.helidon.dbclient.jdbc.JdbcStatementContext;
import io.helidon.dbclient.jdbc.JdbcStatementQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdbcStatementGeneric
extends JdbcStatement<DbStatementGeneric, DbResult>
implements DbStatementGeneric {
    private static final Logger LOGGER = Logger.getLogger(JdbcStatementGeneric.class.getName());

    JdbcStatementGeneric(JdbcExecuteContext executeContext, JdbcStatementContext statementContext) {
        super(executeContext, statementContext);
    }

    protected CompletionStage<DbResult> doExecute(CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> interceptorStatementFuture, CompletableFuture<Long> interceptorQueryFuture) {
        this.executeContext().addFuture(interceptorQueryFuture);
        CompletableFuture queryResultFuture = new CompletableFuture();
        CompletableFuture dmlResultFuture = new CompletableFuture();
        CompletableFuture exceptionFuture = new CompletableFuture();
        CompletableFuture resultSetFuture = new CompletableFuture();
        dbContextFuture.exceptionally(throwable -> {
            resultSetFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        resultSetFuture.exceptionally(throwable -> {
            interceptorStatementFuture.completeExceptionally((Throwable)throwable);
            queryResultFuture.completeExceptionally((Throwable)throwable);
            dmlResultFuture.completeExceptionally((Throwable)throwable);
            exceptionFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        dbContextFuture.thenAccept(dbContext -> this.connection().thenAccept(conn -> this.executorService().submit(() -> {
            block9: {
                try {
                    PreparedStatement statement = super.build((Connection)conn, (DbInterceptorContext)dbContext);
                    boolean isQuery = statement.execute();
                    interceptorStatementFuture.complete(null);
                    if (isQuery) {
                        ResultSet resultSet = statement.getResultSet();
                        resultSetFuture.complete(new JdbcStatementQuery.ResultWithConn(resultSet, (Connection)conn));
                        break block9;
                    }
                    try {
                        long update = statement.getLargeUpdateCount();
                        interceptorQueryFuture.complete(update);
                        dmlResultFuture.complete(update);
                        statement.close();
                    }
                    finally {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    if (null != conn) {
                        try {
                            conn.close();
                        }
                        catch (SQLException ex) {
                            LOGGER.log(Level.WARNING, String.format("Failed to close connection: %s", ex.getMessage()), ex);
                        }
                    }
                    resultSetFuture.completeExceptionally(e);
                }
            }
        })));
        ((CompletableFuture)resultSetFuture.thenAccept(rsAndConn -> {
            DbRows<DbRow> dbRows = JdbcStatementQuery.processResultSet(this.executorService(), this.dbMapperManager(), this.mapperManager(), interceptorQueryFuture, rsAndConn.resultSet());
            interceptorQueryFuture.exceptionally(throwable -> {
                exceptionFuture.complete(throwable);
                return null;
            });
            queryResultFuture.complete(dbRows);
        })).exceptionally(throwable -> {
            interceptorQueryFuture.completeExceptionally((Throwable)throwable);
            queryResultFuture.completeExceptionally((Throwable)throwable);
            exceptionFuture.complete(throwable);
            return null;
        });
        return interceptorStatementFuture.thenApply(nothing -> new GenericDbResult(queryResultFuture, dmlResultFuture, exceptionFuture));
    }

    private static final class GenericDbResult
    implements DbResult {
        private final CompletableFuture<DbRows<DbRow>> queryResultFuture;
        private final CompletableFuture<Long> dmlResultFuture;
        private final CompletableFuture<Throwable> exceptionFuture;

        GenericDbResult(CompletableFuture<DbRows<DbRow>> queryResultFuture, CompletableFuture<Long> dmlResultFuture, CompletableFuture<Throwable> exceptionFuture) {
            this.queryResultFuture = queryResultFuture;
            this.dmlResultFuture = dmlResultFuture;
            this.exceptionFuture = exceptionFuture;
        }

        public DbResult whenDml(Consumer<Long> consumer) {
            this.dmlResultFuture.thenAccept((Consumer)consumer);
            return this;
        }

        public DbResult whenRs(Consumer<DbRows<DbRow>> consumer) {
            this.queryResultFuture.thenAccept((Consumer)consumer);
            return this;
        }

        public DbResult exceptionally(Consumer<Throwable> exceptionHandler) {
            this.exceptionFuture.thenAccept((Consumer)exceptionHandler);
            return this;
        }

        public CompletionStage<Long> dmlFuture() {
            return this.dmlResultFuture;
        }

        public CompletionStage<DbRows<DbRow>> rsFuture() {
            return this.queryResultFuture;
        }

        public CompletionStage<Throwable> exceptionFuture() {
            return this.exceptionFuture;
        }
    }
}

