/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import io.helidon.dbclient.jdbc.JdbcStatementContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class JdbcStatementDml
extends JdbcStatement<DbStatementDml, Long>
implements DbStatementDml {
    JdbcStatementDml(JdbcExecuteContext executeContext, JdbcStatementContext statementContext) {
        super(executeContext, statementContext);
    }

    protected CompletionStage<Long> doExecute(CompletionStage<DbInterceptorContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.executeContext().addFuture(queryFuture);
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            queryFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        return dbContextFuture.thenCompose(dbContext -> this.connection().thenCompose(connection -> {
            this.executorService().submit(() -> {
                try {
                    PreparedStatement preparedStatement = this.build((Connection)connection, (DbInterceptorContext)dbContext);
                    long count = preparedStatement.executeLargeUpdate();
                    statementFuture.complete(null);
                    queryFuture.complete(count);
                    preparedStatement.close();
                }
                catch (Exception e) {
                    statementFuture.completeExceptionally(e);
                    queryFuture.completeExceptionally(e);
                }
            });
            return queryFuture;
        }));
    }
}

