/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbInterceptorContext;
import io.helidon.dbclient.DbStatement;
import io.helidon.dbclient.common.AbstractStatement;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatementContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class JdbcStatement<S extends DbStatement<S, R>, R>
extends AbstractStatement<S, R> {
    private static final Logger LOGGER = Logger.getLogger(JdbcStatement.class.getName());
    private final ExecutorService executorService;
    private final String dbType;
    private final CompletionStage<Connection> connection;
    private final JdbcExecuteContext executeContext;

    JdbcStatement(JdbcExecuteContext executeContext, JdbcStatementContext statementContext) {
        super(statementContext.statementType(), statementContext.statementName(), statementContext.statement(), executeContext.dbMapperManager(), executeContext.mapperManager(), executeContext.interceptors());
        this.executeContext = executeContext;
        this.dbType = executeContext.dbType();
        this.connection = executeContext.connection();
        this.executorService = executeContext.executorService();
    }

    PreparedStatement build(Connection conn, DbInterceptorContext dbContext) {
        LOGGER.fine(() -> String.format("Building SQL statement: %s", dbContext.statement()));
        String statement = dbContext.statement();
        String statementName = dbContext.statementName();
        Supplier<PreparedStatement> simpleStatementSupplier = () -> this.prepareStatement(conn, statementName, statement);
        if (dbContext.isIndexed()) {
            return dbContext.indexedParameters().map(params -> this.prepareIndexedStatement(conn, statementName, statement, (List<Object>)params)).orElseGet(simpleStatementSupplier);
        }
        return dbContext.namedParameters().map(params -> this.prepareNamedStatement(conn, statementName, statement, (Map<String, Object>)params)).orElseGet(simpleStatementSupplier);
    }

    @Deprecated
    protected PreparedStatement build(Connection connection) {
        LOGGER.fine(() -> String.format("Building SQL statement: %s", this.statement()));
        switch (this.paramType()) {
            case UNKNOWN: {
                return this.prepareStatement(connection, this.statementName(), this.statement());
            }
            case INDEXED: {
                return this.prepareIndexedStatement(connection, this.statementName(), this.statement(), this.indexedParams());
            }
            case NAMED: {
                return this.prepareNamedStatement(connection, this.statementName(), this.statement(), this.namedParams());
            }
        }
        throw new IllegalStateException("Unknown SQL statement type");
    }

    protected String dbType() {
        return this.dbType;
    }

    CompletionStage<Connection> connection() {
        return this.connection;
    }

    ExecutorService executorService() {
        return this.executorService;
    }

    JdbcExecuteContext executeContext() {
        return this.executeContext;
    }

    private PreparedStatement prepareStatement(Connection conn, String statementName, String statement) {
        try {
            return conn.prepareStatement(statement);
        }
        catch (SQLException e) {
            throw new DbClientException(String.format("Failed to prepare statement: %s", statementName), (Throwable)e);
        }
    }

    private PreparedStatement prepareNamedStatement(Connection connection, String statementName, String statement, Map<String, Object> parameters) {
        PreparedStatement preparedStatement = null;
        try {
            Parser parser = new Parser(statement);
            String jdbcStatement = parser.convert();
            LOGGER.finest(() -> String.format("Converted statement: %s", jdbcStatement));
            preparedStatement = connection.prepareStatement(jdbcStatement);
            List<String> namesOrder = parser.namesOrder();
            if (namesOrder.size() > parameters.size()) {
                throw new DbClientException(JdbcStatement.namedStatementErrorMessage(namesOrder, parameters));
            }
            int i = 1;
            for (String name : namesOrder) {
                if (parameters.containsKey(name)) {
                    Object value = parameters.get(name);
                    LOGGER.finest(String.format("Mapped parameter %d: %s -> %s", i, name, value));
                    preparedStatement.setObject(i, value);
                    ++i;
                    continue;
                }
                throw new DbClientException(JdbcStatement.namedStatementErrorMessage(namesOrder, parameters));
            }
            return preparedStatement;
        }
        catch (SQLException e) {
            this.closePreparedStatement(preparedStatement);
            throw new DbClientException("Failed to prepare statement with named parameters: " + statementName, (Throwable)e);
        }
    }

    private PreparedStatement prepareIndexedStatement(Connection connection, String statementName, String statement, List<Object> parameters) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(statement);
            int i = 1;
            for (Object value : parameters) {
                LOGGER.finest(String.format("Indexed parameter %d: %s", i, value));
                preparedStatement.setObject(i, value);
                ++i;
            }
            return preparedStatement;
        }
        catch (SQLException e) {
            this.closePreparedStatement(preparedStatement);
            throw new DbClientException(String.format("Failed to prepare statement with indexed params: %s", statementName), (Throwable)e);
        }
    }

    private void closePreparedStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, String.format("Could not close PreparedStatement: %s", e.getMessage()), e);
            }
        }
    }

    private static String namedStatementErrorMessage(List<String> namesOrder, Map<String, Object> parameters) {
        ArrayList<String> notInParams = new ArrayList<String>(namesOrder.size());
        for (String name : namesOrder) {
            if (parameters.containsKey(name)) continue;
            notInParams.add(name);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Query parameters missing in Map: ");
        boolean first = true;
        for (String name : notInParams) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    static final class Parser {
        private static final Action[][] ACTION = new Action[][]{{Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::doNothing, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar}, {Parser::setFirstParamChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColonAndCopyChar, Parser::addColon, Parser::addColonAndCopyChar}, {Parser::setNextParamChar, Parser::setNextParamChar, Parser::finishParamAndCopyChar, Parser::finishParamAndCopyChar, Parser::finishParamAndCopyChar, Parser::finishParamAndCopyChar, Parser::finishParamAndCopyChar, Parser::finishParamAndCopyChar, Parser::finishParam, Parser::finishParamAndCopyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::doNothing, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::doNothing, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar}, {Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar, Parser::copyChar}};
        private final String statement;
        private final StringBuilder sb;
        private final StringBuilder nap;
        private final List<String> names;
        private char c;
        private CharClass cl;

        private static void doNothing(Parser parser) {
        }

        private static void copyChar(Parser parser) {
            parser.sb.append(parser.c);
        }

        private static void addColon(Parser parser) {
            parser.sb.append(':');
        }

        private static void addColonAndCopyChar(Parser parser) {
            parser.sb.append(':');
            parser.sb.append(parser.c);
        }

        private static void setFirstParamChar(Parser parser) {
            parser.nap.setLength(0);
            parser.nap.append(parser.c);
        }

        private static void setNextParamChar(Parser parser) {
            parser.nap.append(parser.c);
        }

        private static void finishParamAndCopyChar(Parser parser) {
            String parName = parser.nap.toString();
            parser.names.add(parName);
            parser.sb.append('?');
            parser.sb.append(parser.c);
        }

        private static void finishParam(Parser parser) {
            String parName = parser.nap.toString();
            parser.names.add(parName);
            parser.sb.append('?');
        }

        Parser(String statement) {
            this.sb = new StringBuilder(statement.length());
            this.nap = new StringBuilder(32);
            this.names = new LinkedList<String>();
            this.statement = statement;
            this.c = '\u0000';
            this.cl = null;
        }

        String convert() {
            State state = State.STATEMENT;
            int len = this.statement.length();
            for (int i = 0; i < len; ++i) {
                this.c = this.statement.charAt(i);
                this.cl = CharClass.charClass(this.c);
                ACTION[state.ordinal()][this.cl.ordinal()].accept(this);
                state = State.TRANSITION[state.ordinal()][this.cl.ordinal()];
            }
            if (state == State.PARAMETER) {
                String parName = this.nap.toString();
                this.names.add(parName);
                this.sb.append('?');
            }
            return this.sb.toString();
        }

        List<String> namesOrder() {
            return this.names;
        }

        private static enum State {
            STATEMENT,
            STRING,
            COLON,
            PARAMETER,
            MULTILN_COMMENT_BG,
            MULTILN_COMMENT_END,
            MULTILN_COMMENT,
            SINGLELN_COMMENT_BG,
            SINGLELN_COMMENT_END,
            SINGLELN_COMMENT;

            private static final State[][] TRANSITION;

            static {
                TRANSITION = new State[][]{{STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {STRING, STRING, STRING, STRING, STATEMENT, STRING, STRING, STRING, STRING, STRING}, {PARAMETER, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {PARAMETER, PARAMETER, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, MULTILN_COMMENT, SINGLELN_COMMENT_BG, MULTILN_COMMENT_BG, COLON, STATEMENT}, {MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT_END, MULTILN_COMMENT, STATEMENT, MULTILN_COMMENT, MULTILN_COMMENT}, {MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT_END, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT, MULTILN_COMMENT}, {STATEMENT, STATEMENT, STATEMENT, STATEMENT, STRING, STATEMENT, SINGLELN_COMMENT, MULTILN_COMMENT_BG, COLON, STATEMENT}, {SINGLELN_COMMENT, SINGLELN_COMMENT, STATEMENT, SINGLELN_COMMENT_END, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT}, {SINGLELN_COMMENT, SINGLELN_COMMENT, STATEMENT, SINGLELN_COMMENT_END, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT, SINGLELN_COMMENT}};
            }
        }

        private static enum CharClass {
            LETTER,
            NUMBER,
            LF,
            CR,
            APOSTROPHE,
            STAR,
            DASH,
            SLASH,
            COLON,
            OTHER;


            private static CharClass charClass(char c) {
                switch (c) {
                    case '\r': {
                        return CR;
                    }
                    case '\n': {
                        return LF;
                    }
                    case '\'': {
                        return APOSTROPHE;
                    }
                    case '*': {
                        return STAR;
                    }
                    case '-': {
                        return DASH;
                    }
                    case '/': {
                        return SLASH;
                    }
                    case ':': {
                        return COLON;
                    }
                }
                return Character.isLetter(c) ? LETTER : (Character.isDigit(c) ? NUMBER : OTHER);
            }
        }

        @FunctionalInterface
        private static interface Action
        extends Consumer<Parser> {
        }
    }
}

