/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.common.InterceptorSupport;
import java.sql.Connection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

final class JdbcExecuteContext {
    private final ExecutorService executorService;
    private final InterceptorSupport interceptors;
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;
    private final String dbType;
    private final CompletionStage<Connection> connection;
    private final ConcurrentHashMap.KeySetView<CompletableFuture<Long>, Boolean> futures = ConcurrentHashMap.newKeySet();

    private JdbcExecuteContext(ExecutorService executorService, InterceptorSupport interceptors, DbMapperManager dbMapperManager, MapperManager mapperManager, String dbType, CompletionStage<Connection> connection) {
        this.executorService = executorService;
        this.interceptors = interceptors;
        this.dbMapperManager = dbMapperManager;
        this.mapperManager = mapperManager;
        this.dbType = dbType;
        this.connection = connection;
    }

    static JdbcExecuteContext create(ExecutorService executorService, InterceptorSupport interceptors, String dbType, CompletionStage<Connection> connection, DbMapperManager dbMapperManager, MapperManager mapperManager) {
        return new JdbcExecuteContext(executorService, interceptors, dbMapperManager, mapperManager, dbType, connection);
    }

    ExecutorService executorService() {
        return this.executorService;
    }

    InterceptorSupport interceptors() {
        return this.interceptors;
    }

    DbMapperManager dbMapperManager() {
        return this.dbMapperManager;
    }

    MapperManager mapperManager() {
        return this.mapperManager;
    }

    String dbType() {
        return this.dbType;
    }

    CompletionStage<Connection> connection() {
        return this.connection;
    }

    void addFuture(CompletableFuture<Long> queryFuture) {
        this.futures.add(queryFuture);
    }

    public CompletionStage<Void> whenComplete() {
        CompletionStage<Object> overallStage = CompletableFuture.completedFuture(null);
        for (CompletableFuture<Long> future : this.futures) {
            overallStage = overallStage.thenCompose(o -> future);
        }
        return overallStage.thenAccept(it -> {});
    }
}

