/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGeneric;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.common.AbstractDbExecute;
import io.helidon.dbclient.common.InterceptorSupport;
import io.helidon.dbclient.jdbc.ConnectionPool;
import io.helidon.dbclient.jdbc.JdbcDbClientProviderBuilder;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatementContext;
import io.helidon.dbclient.jdbc.JdbcStatementDml;
import io.helidon.dbclient.jdbc.JdbcStatementGeneric;
import io.helidon.dbclient.jdbc.JdbcStatementGet;
import io.helidon.dbclient.jdbc.JdbcStatementQuery;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdbcDbClient
implements DbClient {
    private static final Logger LOGGER;
    private final ExecutorService executorService;
    private final ConnectionPool connectionPool;
    private final DbStatements statements;
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;
    private final InterceptorSupport interceptors;

    JdbcDbClient(JdbcDbClientProviderBuilder builder) {
        this.executorService = builder.executorService();
        this.connectionPool = builder.connectionPool();
        this.statements = builder.statements();
        this.dbMapperManager = builder.dbMapperManager();
        this.mapperManager = builder.mapperManager();
        this.interceptors = builder.interceptors();
    }

    public <T> CompletionStage<T> inTransaction(Function<DbTransaction, CompletionStage<T>> executor) {
        JdbcTxExecute execute = new JdbcTxExecute(this.statements, this.executorService, this.interceptors, this.connectionPool, this.dbMapperManager, this.mapperManager);
        CompletionStage<Object> stage = executor.apply(execute).thenApply(it -> {
            execute.context().whenComplete().thenAccept(nothing -> {
                LOGGER.finest(() -> "Transaction commit");
                execute.doCommit().exceptionally(RollbackHandler.create(execute, Level.WARNING));
            }).exceptionally(RollbackHandler.create(execute, Level.WARNING));
            return it;
        });
        stage.exceptionally(RollbackHandler.create(execute, Level.FINEST));
        return stage;
    }

    public <T extends CompletionStage<?>> T execute(Function<DbExecute, T> executor) {
        JdbcExecute execute = new JdbcExecute(this.statements, this.executorService, this.interceptors, this.connectionPool, this.dbMapperManager, this.mapperManager);
        CompletionStage resultFuture = (CompletionStage)executor.apply((DbExecute)execute);
        resultFuture.thenApply(it -> {
            execute.context().whenComplete().thenAccept(nothing -> {
                LOGGER.finest(() -> "Execution finished, closing connection");
                execute.close();
            }).exceptionally(throwable -> {
                LOGGER.log(Level.WARNING, String.format("Execution failed: %s", throwable.getMessage()), (Throwable)throwable);
                execute.close();
                return null;
            });
            return it;
        });
        resultFuture.exceptionally(throwable -> {
            LOGGER.log(Level.FINEST, String.format("Execution failed: %s", throwable.getMessage()), (Throwable)throwable);
            execute.close();
            return null;
        });
        return (T)resultFuture;
    }

    public CompletionStage<Void> ping() {
        return this.execute(exec -> exec.namedUpdate("ping", new Object[0])).thenRun(() -> {});
    }

    public String dbType() {
        return this.connectionPool.dbType();
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"DbClient", "JDBC"});
        LOGGER = Logger.getLogger(DbClient.class.getName());
    }

    private static class JdbcExecute
    extends AbstractDbExecute {
        private final JdbcExecuteContext context;

        private JdbcExecute(DbStatements statements, JdbcExecuteContext context) {
            super(statements);
            this.context = context;
        }

        private JdbcExecute(DbStatements statements, ExecutorService executorService, InterceptorSupport interceptors, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            this(statements, JdbcExecute.createContext(executorService, interceptors, connectionPool, dbMapperManager, mapperManager));
        }

        private static JdbcExecuteContext createContext(ExecutorService executorService, InterceptorSupport interceptors, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            CompletionStage connection = CompletableFuture.supplyAsync(connectionPool::connection, executorService).thenApply(conn -> {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to set autocommit to true", (Throwable)e);
                }
                return conn;
            });
            return JdbcExecuteContext.create(executorService, interceptors, connectionPool.dbType(), connection, dbMapperManager, mapperManager);
        }

        public DbStatementQuery createNamedQuery(String statementName, String statement) {
            return new JdbcStatementQuery(this.context, JdbcStatementContext.create(DbStatementType.QUERY, statementName, statement));
        }

        public DbStatementGet createNamedGet(String statementName, String statement) {
            return new JdbcStatementGet(this.context, JdbcStatementContext.create(DbStatementType.GET, statementName, statement));
        }

        public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
            return new JdbcStatementDml(this.context, JdbcStatementContext.create(DbStatementType.DML, statementName, statement));
        }

        public DbStatementDml createNamedInsert(String statementName, String statement) {
            return new JdbcStatementDml(this.context, JdbcStatementContext.create(DbStatementType.INSERT, statementName, statement));
        }

        public DbStatementDml createNamedUpdate(String statementName, String statement) {
            return new JdbcStatementDml(this.context, JdbcStatementContext.create(DbStatementType.UPDATE, statementName, statement));
        }

        public DbStatementDml createNamedDelete(String statementName, String statement) {
            return new JdbcStatementDml(this.context, JdbcStatementContext.create(DbStatementType.DELETE, statementName, statement));
        }

        public DbStatementGeneric createNamedStatement(String statementName, String statement) {
            return new JdbcStatementGeneric(this.context, JdbcStatementContext.create(DbStatementType.UNKNOWN, statementName, statement));
        }

        JdbcExecuteContext context() {
            return this.context;
        }

        void close() {
            this.context.connection().thenAccept(conn -> {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, String.format("Could not close connection: %s", e.getMessage()), e);
                }
            });
        }
    }

    private static final class JdbcTxExecute
    extends JdbcExecute
    implements DbTransaction {
        private volatile boolean setRollbackOnly = false;

        private JdbcTxExecute(DbStatements statements, ExecutorService executorService, InterceptorSupport interceptors, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            super(statements, JdbcTxExecute.createTxContext(executorService, interceptors, connectionPool, dbMapperManager, mapperManager));
        }

        private static JdbcExecuteContext createTxContext(ExecutorService executorService, InterceptorSupport interceptors, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            CompletionStage connection = CompletableFuture.supplyAsync(connectionPool::connection, executorService).thenApply(conn -> {
                try {
                    conn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to set autocommit to false", (Throwable)e);
                }
                return conn;
            });
            return JdbcExecuteContext.create(executorService, interceptors, connectionPool.dbType(), connection, dbMapperManager, mapperManager);
        }

        public void rollback() {
            this.setRollbackOnly = true;
        }

        private CompletionStage<Connection> doRollback() {
            return this.context().connection().thenApply(conn -> {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to rollback a transaction, or close a connection", (Throwable)e);
                }
                return conn;
            });
        }

        private CompletionStage<Connection> doCommit() {
            if (this.setRollbackOnly) {
                return this.doRollback();
            }
            return this.context().connection().thenApply(conn -> {
                try {
                    conn.commit();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to commit a transaction, or close a connection", (Throwable)e);
                }
                return conn;
            });
        }
    }

    private static final class RollbackHandler<T>
    implements Function<Throwable, T> {
        private final JdbcTxExecute execute;
        private final Level level;

        private static RollbackHandler create(JdbcTxExecute execute, Level level) {
            return new RollbackHandler(execute, level);
        }

        private RollbackHandler(JdbcTxExecute execute, Level level) {
            this.execute = execute;
            this.level = level;
        }

        @Override
        public T apply(Throwable t) {
            LOGGER.log(this.level, String.format("Transaction rollback: %s", t.getMessage()), t);
            this.execute.doRollback().exceptionally(t2 -> {
                LOGGER.log(this.level, String.format("Transaction rollback failed: %s", t2.getMessage()), (Throwable)t2);
                return null;
            });
            return null;
        }
    }
}

