/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.testing;

import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.MapConfigSource;
import io.helidon.config.spi.ConfigSource;
import io.helidon.data.sql.testing.ConfigUtils;
import io.helidon.data.sql.testing.TestConfigFactory;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class TestContainerHandler {
    private final Supplier<? extends ConfigSource> configSource;
    private final String username;
    private final String password;
    private final String url;
    private final GenericContainer<?> container;
    private final int originalPort;

    TestContainerHandler(Supplier<? extends ConfigSource> configSource, String username, String password, String url, GenericContainer<?> container) {
        this.configSource = configSource;
        this.username = username;
        this.password = password;
        this.url = url;
        this.container = container;
        this.originalPort = ConfigUtils.portFromDbUrl(url);
    }

    public int startContainer() {
        this.container.start();
        return this.container.getMappedPort(this.originalPort);
    }

    public Config setConfig() {
        Config newConfig = this.config();
        TestConfigFactory.config((io.helidon.common.config.Config)newConfig);
        return newConfig;
    }

    public Config config() {
        if (this.container.isRunning()) {
            String newUrl = ConfigUtils.replacePortInUrl(this.url, this.container.getMappedPort(this.originalPort));
            MapConfigSource mySource = ((MapConfigSource.Builder)ConfigSources.create(Map.of("test.database.url", newUrl)).name("test-containers-updated-values")).build();
            return Config.just((Supplier[])new Supplier[]{mySource, this.configSource});
        }
        return Config.just((Supplier[])new Supplier[]{this.configSource});
    }

    public int originalPort() {
        return this.originalPort;
    }

    public void stopContainer() {
        this.container.stop();
    }

    void configureContainer() {
        GenericContainer<?> genericContainer = this.container;
        if (genericContainer instanceof JdbcDatabaseContainer) {
            JdbcDatabaseContainer dbContainer = (JdbcDatabaseContainer)genericContainer;
            dbContainer.withUsername(this.username).withPassword(this.password);
            Optional.of(this.url).map(ConfigUtils::uriFromDbUrl).map(ConfigUtils::dbNameFromUri).ifPresent(arg_0 -> ((JdbcDatabaseContainer)dbContainer).withDatabaseName(arg_0));
        }
    }
}

