/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.common;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.common.SqlConfigBlueprint;
import io.helidon.data.sql.common.SqlConfigSupport;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.common.SqlConfigBlueprint")
public interface SqlConfig
extends SqlConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SqlConfig instance) {
        return (Builder)SqlConfig.builder().from(instance);
    }

    @Deprecated
    public static SqlConfig create(io.helidon.common.config.Config config) {
        return SqlConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static SqlConfig create(Config config) {
        return ((Builder)SqlConfig.builder().config(config)).buildPrototype();
    }

    @Override
    public Optional<ConnectionConfig> connection();

    @Override
    public Optional<String> dataSource();

    public static class Builder
    extends BuilderBase<Builder, SqlConfig>
    implements io.helidon.common.Builder<Builder, SqlConfig> {
        private Builder() {
        }

        public SqlConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SqlConfigImpl(this);
        }

        public SqlConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SqlConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Config config;
        private ConnectionConfig connection;
        private String dataSource;

        protected BuilderBase() {
        }

        public BUILDER from(SqlConfig prototype) {
            this.connection(prototype.connection());
            this.dataSource(prototype.dataSource());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.connection().ifPresent(this::connection);
            builder.dataSource().ifPresent(this::dataSource);
            this.config = builder.config().map(Config::config).orElse(this.config);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("connection").as(ConnectionConfig::create).ifPresent(this::connection);
            config.get("data-source").asString().ifPresent(this::dataSource);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConnection() {
            this.connection = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connection(ConnectionConfig connection) {
            Objects.requireNonNull(connection);
            this.connection = connection;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connection(Consumer<ConnectionConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ConnectionConfig.Builder builder = ConnectionConfig.builder();
            consumer.accept(builder);
            this.connection(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connection(Supplier<? extends ConnectionConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.connection(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDataSource() {
            this.dataSource = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dataSource(String dataSource) {
            Objects.requireNonNull(dataSource);
            this.dataSource = dataSource;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ConnectionConfig> connection() {
            return Optional.ofNullable(this.connection);
        }

        public Optional<String> dataSource() {
            return Optional.ofNullable(this.dataSource);
        }

        public String toString() {
            return "SqlConfigBuilder{connection=" + String.valueOf(this.connection) + ",dataSource=" + this.dataSource + "}";
        }

        protected void preBuildPrototype() {
            new SqlConfigSupport.Decorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        protected Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        BUILDER connection(Optional<? extends ConnectionConfig> connection) {
            Objects.requireNonNull(connection);
            this.connection = connection.map(ConnectionConfig.class::cast).orElse(this.connection);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER dataSource(Optional<String> dataSource) {
            Objects.requireNonNull(dataSource);
            this.dataSource = dataSource.orElse(this.dataSource);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SqlConfigImpl
        implements SqlConfig {
            private final Optional<ConnectionConfig> connection;
            private final Optional<String> dataSource;

            protected SqlConfigImpl(BuilderBase<?, ?> builder) {
                this.connection = builder.connection().map(Function.identity());
                this.dataSource = builder.dataSource().map(Function.identity());
            }

            @Override
            public Optional<ConnectionConfig> connection() {
                return this.connection;
            }

            @Override
            public Optional<String> dataSource() {
                return this.dataSource;
            }

            public String toString() {
                return "SqlConfig{connection=" + String.valueOf(this.connection) + ",dataSource=" + String.valueOf(this.dataSource) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SqlConfig)) {
                    return false;
                }
                SqlConfig other = (SqlConfig)o;
                return Objects.equals(this.connection, other.connection()) && Objects.equals(this.dataSource, other.dataSource());
            }

            public int hashCode() {
                return Objects.hash(this.connection, this.dataSource);
            }
        }
    }
}

