/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.datasource.DataSourceConfigBlueprint;
import io.helidon.data.sql.datasource.ProviderConfig;
import io.helidon.data.sql.datasource.spi.DataSourceConfigProvider;
import io.helidon.service.registry.ServiceRegistry;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.datasource.DataSourceConfigBlueprint")
public interface DataSourceConfig
extends DataSourceConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSourceConfig instance) {
        return (Builder)DataSourceConfig.builder().from(instance);
    }

    public static DataSourceConfig create(Config config) {
        return ((Builder)DataSourceConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static DataSourceConfig create(io.helidon.common.config.Config config) {
        return DataSourceConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    public String name();

    @Override
    public ProviderConfig provider();

    public static class Builder
    extends BuilderBase<Builder, DataSourceConfig>
    implements io.helidon.common.Builder<Builder, DataSourceConfig> {
        private Builder() {
        }

        public DataSourceConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DataSourceConfigImpl(this);
        }

        public DataSourceConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DataSourceConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean providerDiscoverServices = true;
        private Config config;
        private ProviderConfig provider;
        private ServiceRegistry serviceRegistry;
        private String name = "@default";

        protected BuilderBase() {
        }

        public BUILDER from(DataSourceConfig prototype) {
            this.name(prototype.name());
            this.provider(prototype.provider());
            this.providerDiscoverServices = false;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            builder.provider().ifPresent(this::provider);
            this.providerDiscoverServices(builder.providerDiscoverServices());
            this.config = builder.config().map(Config::config).orElse(this.config);
            builder.serviceRegistry().ifPresent(this::serviceRegistry);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").asString().ifPresent(this::name);
            config.get("provider-discover-services").asBoolean().ifPresent(this::providerDiscoverServices);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provider(ProviderConfig provider) {
            Objects.requireNonNull(provider);
            this.provider = provider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerDiscoverServices(boolean providerDiscoverServices) {
            this.providerDiscoverServices = providerDiscoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceRegistry(ServiceRegistry serviceRegistry) {
            Objects.requireNonNull(serviceRegistry);
            this.serviceRegistry = serviceRegistry;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public Optional<ProviderConfig> provider() {
            return Optional.ofNullable(this.provider);
        }

        public boolean providerDiscoverServices() {
            return this.providerDiscoverServices;
        }

        public Optional<ServiceRegistry> serviceRegistry() {
            return Optional.ofNullable(this.serviceRegistry);
        }

        public String toString() {
            return "DataSourceConfigBuilder{name=" + this.name + ",provider=" + String.valueOf(this.provider) + ",providerDiscoverServices=" + this.providerDiscoverServices + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config().map(Config::config).orElseGet(Config::empty);
            Optional<ServiceRegistry> registry = Optional.ofNullable(this.serviceRegistry);
            ConfigBuilderSupport.discoverService((Config)config, (String)"provider", registry, DataSourceConfigProvider.class, ProviderConfig.class, (boolean)this.providerDiscoverServices, Optional.ofNullable(this.provider)).ifPresent(this::provider);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.provider == null) {
                collector.fatal(this.getClass(), "Property \"provider\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        protected static class DataSourceConfigImpl
        implements DataSourceConfig {
            private final ProviderConfig provider;
            private final String name;

            protected DataSourceConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.provider = builder.provider().get();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public ProviderConfig provider() {
                return this.provider;
            }

            public String toString() {
                return "DataSourceConfig{name=" + this.name + ",provider=" + String.valueOf(this.provider) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DataSourceConfig)) {
                    return false;
                }
                DataSourceConfig other = (DataSourceConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.provider, other.provider());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.provider);
            }
        }
    }
}

