/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.ucp;

import io.helidon.data.sql.datasource.DataSourceConfig;
import io.helidon.data.sql.datasource.ProviderConfig;
import io.helidon.data.sql.datasource.ucp.UcpDataSourceConfig;
import io.helidon.data.sql.datasource.ucp.UcpDataSourceFactory;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;

@Service.Named(value="*")
@Service.Singleton
class UcpDataSourceProviderService
implements Service.ServicesFactory<DataSource> {
    static final String PROVIDER_TYPE = "ucp";
    private final Supplier<List<DataSourceConfig>> dsConfigs;

    @Service.Inject
    UcpDataSourceProviderService(Supplier<List<DataSourceConfig>> dsConfigs) {
        this.dsConfigs = dsConfigs;
    }

    public List<Service.QualifiedInstance<DataSource>> services() {
        ArrayList<Service.QualifiedInstance<DataSource>> instances = new ArrayList<Service.QualifiedInstance<DataSource>>();
        for (DataSourceConfig dsConfig : this.dsConfigs.get()) {
            ProviderConfig providerConfig = dsConfig.provider();
            if (!(providerConfig instanceof UcpDataSourceConfig)) continue;
            UcpDataSourceConfig ucpConfig = (UcpDataSourceConfig)providerConfig;
            String name = dsConfig.name();
            instances.add(this.createDataSource(name, ucpConfig));
        }
        return instances;
    }

    private Service.QualifiedInstance<DataSource> createDataSource(String name, UcpDataSourceConfig ucpConfig) {
        return Service.QualifiedInstance.create((Object)UcpDataSourceFactory.create(ucpConfig), (Qualifier[])new Qualifier[]{Qualifier.createNamed((String)name)});
    }
}

