/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.jdbc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.datasource.TransactionIsolation;
import io.helidon.data.sql.datasource.jdbc.JdbcDataSourceConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.datasource.jdbc.JdbcDataSourceConfigBlueprint")
public interface JdbcDataSourceConfig
extends JdbcDataSourceConfigBlueprint,
Prototype.Api,
ConnectionConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JdbcDataSourceConfig instance) {
        return (Builder)((Object)JdbcDataSourceConfig.builder().from(instance));
    }

    public static JdbcDataSourceConfig create(Config config) {
        return ((Builder)JdbcDataSourceConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static JdbcDataSourceConfig create(io.helidon.common.config.Config config) {
        return JdbcDataSourceConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static JdbcDataSourceConfig create() {
        return JdbcDataSourceConfig.builder().buildPrototype();
    }

    @Override
    default public String type() {
        return JdbcDataSourceConfigBlueprint.super.type();
    }

    @Override
    public String name();

    @Override
    public Optional<Boolean> autoCommit();

    @Override
    public Optional<String> catalog();

    @Override
    public Optional<Boolean> readOnly();

    @Override
    public Optional<String> schema();

    @Override
    public Optional<TransactionIsolation> transactionIsolation();

    @Override
    public Map<String, String> properties();

    public static class Builder
    extends BuilderBase<Builder, JdbcDataSourceConfig>
    implements io.helidon.common.Builder<Builder, JdbcDataSourceConfig> {
        private Builder() {
        }

        public JdbcDataSourceConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JdbcDataSourceConfigImpl(this);
        }

        public JdbcDataSourceConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JdbcDataSourceConfig>
    extends ConnectionConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Boolean autoCommit;
        private Boolean readOnly;
        private boolean isPropertiesMutated;
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        private String catalog;
        private String name = "jdbc";
        private String schema;
        private TransactionIsolation transactionIsolation;

        protected BuilderBase() {
        }

        public BUILDER from(JdbcDataSourceConfig prototype) {
            super.from((ConnectionConfig)prototype);
            this.name(prototype.name());
            this.autoCommit(prototype.autoCommit());
            this.catalog(prototype.catalog());
            this.readOnly(prototype.readOnly());
            this.schema(prototype.schema());
            this.transactionIsolation(prototype.transactionIsolation());
            if (!this.isPropertiesMutated) {
                this.properties.clear();
            }
            this.addProperties(prototype.properties());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.name(builder.name());
            builder.autoCommit().ifPresent(this::autoCommit);
            builder.catalog().ifPresent(this::catalog);
            builder.readOnly().ifPresent(this::readOnly);
            builder.schema().ifPresent(this::schema);
            builder.transactionIsolation().ifPresent(this::transactionIsolation);
            if (this.isPropertiesMutated) {
                if (builder.isPropertiesMutated) {
                    this.addProperties(builder.properties());
                }
            } else {
                this.properties(builder.properties());
            }
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            super.config(config);
            config.get("auto-commit").asBoolean().ifPresent(this::autoCommit);
            config.get("catalog").asString().ifPresent(this::catalog);
            config.get("read-only").asBoolean().ifPresent(this::readOnly);
            config.get("schema").asString().ifPresent(this::schema);
            config.get("transaction-isolation").as(TransactionIsolation.class).ifPresent(this::transactionIsolation);
            config.get("properties").detach().asMap().ifPresent(this::properties);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearAutoCommit() {
            this.autoCommit = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearCatalog() {
            this.catalog = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER catalog(String catalog) {
            Objects.requireNonNull(catalog);
            this.catalog = catalog;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearReadOnly() {
            this.readOnly = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearSchema() {
            this.schema = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER schema(String schema) {
            Objects.requireNonNull(schema);
            this.schema = schema;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearTransactionIsolation() {
            this.transactionIsolation = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER transactionIsolation(TransactionIsolation transactionIsolation) {
            Objects.requireNonNull(transactionIsolation);
            this.transactionIsolation = transactionIsolation;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER properties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addProperties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER putProperty(String key, String property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public String name() {
            return this.name;
        }

        public Optional<Boolean> autoCommit() {
            return Optional.ofNullable(this.autoCommit);
        }

        public Optional<String> catalog() {
            return Optional.ofNullable(this.catalog);
        }

        public Optional<Boolean> readOnly() {
            return Optional.ofNullable(this.readOnly);
        }

        public Optional<String> schema() {
            return Optional.ofNullable(this.schema);
        }

        public Optional<TransactionIsolation> transactionIsolation() {
            return Optional.ofNullable(this.transactionIsolation);
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public String toString() {
            return "JdbcDataSourceConfigBuilder{name=" + this.name + ",autoCommit=" + this.autoCommit + ",catalog=" + this.catalog + ",readOnly=" + this.readOnly + ",schema=" + this.schema + ",transactionIsolation=" + String.valueOf(this.transactionIsolation) + ",properties=" + String.valueOf(this.properties) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER autoCommit(Optional<Boolean> autoCommit) {
            Objects.requireNonNull(autoCommit);
            this.autoCommit = autoCommit.orElse(this.autoCommit);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER catalog(Optional<String> catalog) {
            Objects.requireNonNull(catalog);
            this.catalog = catalog.orElse(this.catalog);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER readOnly(Optional<Boolean> readOnly) {
            Objects.requireNonNull(readOnly);
            this.readOnly = readOnly.orElse(this.readOnly);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER schema(Optional<String> schema) {
            Objects.requireNonNull(schema);
            this.schema = schema.orElse(this.schema);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER transactionIsolation(Optional<? extends TransactionIsolation> transactionIsolation) {
            Objects.requireNonNull(transactionIsolation);
            this.transactionIsolation = transactionIsolation.map(TransactionIsolation.class::cast).orElse(this.transactionIsolation);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        protected static class JdbcDataSourceConfigImpl
        extends ConnectionConfig.BuilderBase.ConnectionConfigImpl
        implements JdbcDataSourceConfig {
            private final Map<String, String> properties;
            private final Optional<TransactionIsolation> transactionIsolation;
            private final Optional<Boolean> autoCommit;
            private final Optional<Boolean> readOnly;
            private final Optional<String> catalog;
            private final Optional<String> schema;
            private final String name;

            protected JdbcDataSourceConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.name = builder.name();
                this.autoCommit = builder.autoCommit().map(Function.identity());
                this.catalog = builder.catalog().map(Function.identity());
                this.readOnly = builder.readOnly().map(Function.identity());
                this.schema = builder.schema().map(Function.identity());
                this.transactionIsolation = builder.transactionIsolation().map(Function.identity());
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.properties()));
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<Boolean> autoCommit() {
                return this.autoCommit;
            }

            @Override
            public Optional<String> catalog() {
                return this.catalog;
            }

            @Override
            public Optional<Boolean> readOnly() {
                return this.readOnly;
            }

            @Override
            public Optional<String> schema() {
                return this.schema;
            }

            @Override
            public Optional<TransactionIsolation> transactionIsolation() {
                return this.transactionIsolation;
            }

            @Override
            public Map<String, String> properties() {
                return this.properties;
            }

            public String toString() {
                return "JdbcDataSourceConfig{name=" + this.name + ",autoCommit=" + String.valueOf(this.autoCommit) + ",catalog=" + String.valueOf(this.catalog) + ",readOnly=" + String.valueOf(this.readOnly) + ",schema=" + String.valueOf(this.schema) + ",transactionIsolation=" + String.valueOf(this.transactionIsolation) + ",properties=" + String.valueOf(this.properties) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JdbcDataSourceConfig)) {
                    return false;
                }
                JdbcDataSourceConfig other = (JdbcDataSourceConfig)o;
                return super.equals((Object)other) && Objects.equals(this.name, other.name()) && Objects.equals(this.autoCommit, other.autoCommit()) && Objects.equals(this.catalog, other.catalog()) && Objects.equals(this.readOnly, other.readOnly()) && Objects.equals(this.schema, other.schema()) && Objects.equals(this.transactionIsolation, other.transactionIsolation()) && Objects.equals(this.properties, other.properties());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.name, this.autoCommit, this.catalog, this.readOnly, this.schema, this.transactionIsolation, this.properties);
            }
        }
    }
}

