/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.jdbc;

import io.helidon.data.sql.common.SqlDriver;
import io.helidon.data.sql.datasource.jdbc.CommonDataSourceBase;
import io.helidon.data.sql.datasource.jdbc.JdbcDataSourceConfig;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

class JdbcDataSource
extends CommonDataSourceBase
implements DataSource {
    private final JdbcDataSourceConfig providerConfig;
    private final Driver driver;
    private final Properties properties;

    JdbcDataSource(JdbcDataSourceConfig providerConfig, SqlDriver driver) {
        this.providerConfig = providerConfig;
        this.driver = driver.driver();
        this.properties = new Properties();
        this.properties.putAll(providerConfig.properties());
        providerConfig.username().ifPresent(it -> this.properties.put("user", it));
        providerConfig.password().ifPresent(it -> this.properties.put("password", it));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties propertiesCopy = new Properties(this.properties);
        if (username == null) {
            propertiesCopy.remove("username");
        } else {
            propertiesCopy.put("user", username);
        }
        if (password == null) {
            propertiesCopy.remove("password");
        } else {
            propertiesCopy.put("password", password);
        }
        return this.getConnection(propertiesCopy);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        if (iface.isInstance(this.driver)) {
            return iface.cast(this.driver);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName() + ", current driver class: " + this.driver.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this) || iface.isInstance(this.driver);
    }

    private Connection getConnection(Properties properties) throws SQLException {
        Connection connection = this.driver.connect(this.providerConfig.url(), properties);
        if (this.providerConfig.autoCommit().isPresent()) {
            connection.setAutoCommit(this.providerConfig.autoCommit().get());
        }
        if (this.providerConfig.catalog().isPresent()) {
            connection.setCatalog(this.providerConfig.catalog().get());
        }
        if (this.providerConfig.transactionIsolation().isPresent()) {
            connection.setTransactionIsolation(this.providerConfig.transactionIsolation().get().level());
        }
        if (this.providerConfig.schema().isPresent()) {
            connection.setSchema(this.providerConfig.schema().get());
        }
        if (this.providerConfig.readOnly().isPresent()) {
            connection.setReadOnly(this.providerConfig.readOnly().get());
        }
        return connection;
    }
}

