/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.helidon.common.config.Config;
import io.helidon.data.sql.datasource.hikari.HikariDataSourceConfig;
import javax.sql.DataSource;

public class HikariDataSourceFactory {
    private final HikariDataSourceConfig dataSourceConfig;
    private final HikariConfig hikariConfig;

    private HikariDataSourceFactory(HikariDataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        this.hikariConfig = new HikariConfig();
    }

    public static DataSource create(Config config) {
        return HikariDataSourceFactory.create(HikariDataSourceConfig.create(config));
    }

    public static DataSource create(HikariDataSourceConfig dataSourceConfig) {
        return new HikariDataSourceFactory(dataSourceConfig).create();
    }

    private DataSource create() {
        this.dataSourceConfig.allowPoolSuspension().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setAllowPoolSuspension(arg_0));
        this.dataSourceConfig.autoCommit().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setAutoCommit(arg_0));
        this.dataSourceConfig.catalog().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setCatalog(arg_0));
        this.dataSourceConfig.connectionInitSql().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setConnectionInitSql(arg_0));
        this.dataSourceConfig.connectionTestQuery().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setConnectionTestQuery(arg_0));
        this.dataSourceConfig.connectionTimeout().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setConnectionTimeout(arg_0));
        this.hikariConfig.setJdbcUrl(this.dataSourceConfig.url());
        this.dataSourceConfig.jdbcDriverClassName().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setDriverClassName(arg_0));
        this.dataSourceConfig.healthCheckProperties().forEach((arg_0, arg_1) -> ((HikariConfig)this.hikariConfig).addHealthCheckProperty(arg_0, arg_1));
        this.dataSourceConfig.idleTimeout().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setIdleTimeout(arg_0));
        this.dataSourceConfig.initializationFailTimeout().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setInitializationFailTimeout(arg_0));
        this.dataSourceConfig.isolateInternalQueries().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setIsolateInternalQueries(arg_0));
        this.dataSourceConfig.keepaliveTime().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setKeepaliveTime(arg_0));
        this.dataSourceConfig.leakDetectionThreshold().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setLeakDetectionThreshold(arg_0));
        this.dataSourceConfig.maximumPoolSize().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setMaximumPoolSize(arg_0));
        this.dataSourceConfig.maxLifetime().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setMaxLifetime(arg_0));
        this.dataSourceConfig.minimumIdle().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setMinimumIdle(arg_0));
        this.dataSourceConfig.password().ifPresent(this::setPassword);
        this.dataSourceConfig.poolName().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setPoolName(arg_0));
        this.dataSourceConfig.properties().forEach((arg_0, arg_1) -> ((HikariConfig)this.hikariConfig).addDataSourceProperty(arg_0, arg_1));
        this.dataSourceConfig.readOnly().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setReadOnly(arg_0));
        this.dataSourceConfig.registerMbeans().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setRegisterMbeans(arg_0));
        this.dataSourceConfig.schema().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setSchema(arg_0));
        this.dataSourceConfig.transactionIsolation().map(Enum::name).ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setTransactionIsolation(arg_0));
        this.dataSourceConfig.validationTimeout().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setValidationTimeout(arg_0));
        this.dataSourceConfig.username().ifPresent(arg_0 -> ((HikariConfig)this.hikariConfig).setUsername(arg_0));
        return new HikariDataSource(this.hikariConfig);
    }

    private void setPassword(char[] password) {
        this.hikariConfig.setPassword(new String(password));
    }
}

