/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.hikari;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.datasource.TransactionIsolation;
import io.helidon.data.sql.datasource.hikari.HikariDataSourceConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.datasource.hikari.HikariDataSourceConfigBlueprint")
public interface HikariDataSourceConfig
extends HikariDataSourceConfigBlueprint,
Prototype.Api,
ConnectionConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HikariDataSourceConfig instance) {
        return (Builder)((Object)HikariDataSourceConfig.builder().from(instance));
    }

    public static HikariDataSourceConfig create(Config config) {
        return ((Builder)HikariDataSourceConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static HikariDataSourceConfig create(io.helidon.common.config.Config config) {
        return HikariDataSourceConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    default public String type() {
        return HikariDataSourceConfigBlueprint.super.type();
    }

    @Override
    public String name();

    @Override
    public Optional<Boolean> allowPoolSuspension();

    @Override
    public Optional<Boolean> autoCommit();

    @Override
    public Optional<String> catalog();

    @Override
    public Optional<String> connectionInitSql();

    @Override
    public Optional<String> connectionTestQuery();

    @Override
    public Optional<Long> connectionTimeout();

    @Override
    public Map<String, String> healthCheckProperties();

    @Override
    public Optional<Long> idleTimeout();

    @Override
    public Optional<Long> initializationFailTimeout();

    @Override
    public Optional<Boolean> isolateInternalQueries();

    @Override
    public Optional<Long> keepaliveTime();

    @Override
    public Optional<Long> leakDetectionThreshold();

    @Override
    public Optional<Integer> maximumPoolSize();

    @Override
    public Optional<Long> maxLifetime();

    @Override
    public Optional<Integer> minimumIdle();

    @Override
    public Optional<String> poolName();

    @Override
    public Optional<Boolean> readOnly();

    @Override
    public Optional<Boolean> registerMbeans();

    @Override
    public Optional<String> schema();

    @Override
    public Optional<TransactionIsolation> transactionIsolation();

    @Override
    public Optional<Long> validationTimeout();

    @Override
    public Map<String, String> properties();

    public static class Builder
    extends BuilderBase<Builder, HikariDataSourceConfig>
    implements io.helidon.common.Builder<Builder, HikariDataSourceConfig> {
        private Builder() {
        }

        public HikariDataSourceConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.HikariDataSourceConfigImpl(this);
        }

        public HikariDataSourceConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends HikariDataSourceConfig>
    extends ConnectionConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private Boolean allowPoolSuspension;
        private Boolean autoCommit;
        private Boolean isolateInternalQueries;
        private Boolean readOnly;
        private Boolean registerMbeans;
        private boolean isHealthCheckPropertiesMutated;
        private boolean isPropertiesMutated;
        private Integer maximumPoolSize;
        private Integer minimumIdle;
        private Long connectionTimeout;
        private Long idleTimeout;
        private Long initializationFailTimeout;
        private Long keepaliveTime;
        private Long leakDetectionThreshold;
        private Long maxLifetime;
        private Long validationTimeout;
        private Map<String, String> healthCheckProperties = new LinkedHashMap<String, String>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        private String catalog;
        private String connectionInitSql;
        private String connectionTestQuery;
        private String name;
        private String poolName;
        private String schema;
        private TransactionIsolation transactionIsolation;

        protected BuilderBase() {
        }

        public BUILDER from(HikariDataSourceConfig prototype) {
            super.from((ConnectionConfig)prototype);
            this.name(prototype.name());
            this.allowPoolSuspension(prototype.allowPoolSuspension());
            this.autoCommit(prototype.autoCommit());
            this.catalog(prototype.catalog());
            this.connectionInitSql(prototype.connectionInitSql());
            this.connectionTestQuery(prototype.connectionTestQuery());
            this.connectionTimeout(prototype.connectionTimeout());
            if (!this.isHealthCheckPropertiesMutated) {
                this.healthCheckProperties.clear();
            }
            this.addHealthCheckProperties(prototype.healthCheckProperties());
            this.idleTimeout(prototype.idleTimeout());
            this.initializationFailTimeout(prototype.initializationFailTimeout());
            this.isolateInternalQueries(prototype.isolateInternalQueries());
            this.keepaliveTime(prototype.keepaliveTime());
            this.leakDetectionThreshold(prototype.leakDetectionThreshold());
            this.maximumPoolSize(prototype.maximumPoolSize());
            this.maxLifetime(prototype.maxLifetime());
            this.minimumIdle(prototype.minimumIdle());
            this.poolName(prototype.poolName());
            this.readOnly(prototype.readOnly());
            this.registerMbeans(prototype.registerMbeans());
            this.schema(prototype.schema());
            this.transactionIsolation(prototype.transactionIsolation());
            this.validationTimeout(prototype.validationTimeout());
            if (!this.isPropertiesMutated) {
                this.properties.clear();
            }
            this.addProperties(prototype.properties());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.name().ifPresent(this::name);
            builder.allowPoolSuspension().ifPresent(this::allowPoolSuspension);
            builder.autoCommit().ifPresent(this::autoCommit);
            builder.catalog().ifPresent(this::catalog);
            builder.connectionInitSql().ifPresent(this::connectionInitSql);
            builder.connectionTestQuery().ifPresent(this::connectionTestQuery);
            builder.connectionTimeout().ifPresent(this::connectionTimeout);
            if (this.isHealthCheckPropertiesMutated) {
                if (builder.isHealthCheckPropertiesMutated) {
                    this.addHealthCheckProperties(builder.healthCheckProperties());
                }
            } else {
                this.healthCheckProperties(builder.healthCheckProperties());
            }
            builder.idleTimeout().ifPresent(this::idleTimeout);
            builder.initializationFailTimeout().ifPresent(this::initializationFailTimeout);
            builder.isolateInternalQueries().ifPresent(this::isolateInternalQueries);
            builder.keepaliveTime().ifPresent(this::keepaliveTime);
            builder.leakDetectionThreshold().ifPresent(this::leakDetectionThreshold);
            builder.maximumPoolSize().ifPresent(this::maximumPoolSize);
            builder.maxLifetime().ifPresent(this::maxLifetime);
            builder.minimumIdle().ifPresent(this::minimumIdle);
            builder.poolName().ifPresent(this::poolName);
            builder.readOnly().ifPresent(this::readOnly);
            builder.registerMbeans().ifPresent(this::registerMbeans);
            builder.schema().ifPresent(this::schema);
            builder.transactionIsolation().ifPresent(this::transactionIsolation);
            builder.validationTimeout().ifPresent(this::validationTimeout);
            if (this.isPropertiesMutated) {
                if (builder.isPropertiesMutated) {
                    this.addProperties(builder.properties());
                }
            } else {
                this.properties(builder.properties());
            }
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            super.config(config);
            config.get("allow-pool-suspension").asBoolean().ifPresent(this::allowPoolSuspension);
            config.get("auto-commit").asBoolean().ifPresent(this::autoCommit);
            config.get("catalog").asString().ifPresent(this::catalog);
            config.get("connection-init-sql").asString().ifPresent(this::connectionInitSql);
            config.get("connection-test-query").asString().ifPresent(this::connectionTestQuery);
            config.get("connection-timeout").asLong().ifPresent(this::connectionTimeout);
            config.get("health-check-properties").detach().asMap().ifPresent(this::healthCheckProperties);
            config.get("idle-timeout").asLong().ifPresent(this::idleTimeout);
            config.get("initialization-fail-timeout").asLong().ifPresent(this::initializationFailTimeout);
            config.get("isolate-internal-queries").asBoolean().ifPresent(this::isolateInternalQueries);
            config.get("keepalive-time").asLong().ifPresent(this::keepaliveTime);
            config.get("leak-detection-threshold").asLong().ifPresent(this::leakDetectionThreshold);
            config.get("maximum-pool-size").asInt().ifPresent(this::maximumPoolSize);
            config.get("max-lifetime").asLong().ifPresent(this::maxLifetime);
            config.get("minimum-idle").asInt().ifPresent(this::minimumIdle);
            config.get("pool-name").asString().ifPresent(this::poolName);
            config.get("read-only").asBoolean().ifPresent(this::readOnly);
            config.get("register-mbeans").asBoolean().ifPresent(this::registerMbeans);
            config.get("schema").asString().ifPresent(this::schema);
            config.get("transaction-isolation").as(TransactionIsolation.class).ifPresent(this::transactionIsolation);
            config.get("validation-timeout").asLong().ifPresent(this::validationTimeout);
            config.get("properties").detach().asMap().ifPresent(this::properties);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearAllowPoolSuspension() {
            this.allowPoolSuspension = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER allowPoolSuspension(boolean allowPoolSuspension) {
            this.allowPoolSuspension = allowPoolSuspension;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearAutoCommit() {
            this.autoCommit = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearCatalog() {
            this.catalog = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER catalog(String catalog) {
            Objects.requireNonNull(catalog);
            this.catalog = catalog;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionInitSql() {
            this.connectionInitSql = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionInitSql(String connectionInitSql) {
            Objects.requireNonNull(connectionInitSql);
            this.connectionInitSql = connectionInitSql;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionTestQuery() {
            this.connectionTestQuery = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionTestQuery(String connectionTestQuery) {
            Objects.requireNonNull(connectionTestQuery);
            this.connectionTestQuery = connectionTestQuery;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearConnectionTimeout() {
            this.connectionTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER healthCheckProperties(Map<String, String> healthCheckProperties) {
            Objects.requireNonNull(healthCheckProperties);
            this.healthCheckProperties.clear();
            this.healthCheckProperties.putAll(healthCheckProperties);
            this.isHealthCheckPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addHealthCheckProperties(Map<String, String> healthCheckProperties) {
            Objects.requireNonNull(healthCheckProperties);
            this.healthCheckProperties.putAll(healthCheckProperties);
            this.isHealthCheckPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER putHealthCheckProperty(String key, String healthCheckProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(healthCheckProperty);
            this.healthCheckProperties.put(key, healthCheckProperty);
            this.isHealthCheckPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearIdleTimeout() {
            this.idleTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER idleTimeout(long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearInitializationFailTimeout() {
            this.initializationFailTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER initializationFailTimeout(long initializationFailTimeout) {
            this.initializationFailTimeout = initializationFailTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearIsolateInternalQueries() {
            this.isolateInternalQueries = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER isolateInternalQueries(boolean isolateInternalQueries) {
            this.isolateInternalQueries = isolateInternalQueries;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearKeepaliveTime() {
            this.keepaliveTime = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER keepaliveTime(long keepaliveTime) {
            this.keepaliveTime = keepaliveTime;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearLeakDetectionThreshold() {
            this.leakDetectionThreshold = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER leakDetectionThreshold(long leakDetectionThreshold) {
            this.leakDetectionThreshold = leakDetectionThreshold;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaximumPoolSize() {
            this.maximumPoolSize = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMaxLifetime() {
            this.maxLifetime = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER maxLifetime(long maxLifetime) {
            this.maxLifetime = maxLifetime;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearMinimumIdle() {
            this.minimumIdle = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER minimumIdle(int minimumIdle) {
            this.minimumIdle = minimumIdle;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearPoolName() {
            this.poolName = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER poolName(String poolName) {
            Objects.requireNonNull(poolName);
            this.poolName = poolName;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearReadOnly() {
            this.readOnly = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearRegisterMbeans() {
            this.registerMbeans = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER registerMbeans(boolean registerMbeans) {
            this.registerMbeans = registerMbeans;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearSchema() {
            this.schema = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER schema(String schema) {
            Objects.requireNonNull(schema);
            this.schema = schema;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearTransactionIsolation() {
            this.transactionIsolation = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER transactionIsolation(TransactionIsolation transactionIsolation) {
            Objects.requireNonNull(transactionIsolation);
            this.transactionIsolation = transactionIsolation;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearValidationTimeout() {
            this.validationTimeout = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER validationTimeout(long validationTimeout) {
            this.validationTimeout = validationTimeout;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER properties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addProperties(Map<String, String> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER putProperty(String key, String property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            this.isPropertiesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<Boolean> allowPoolSuspension() {
            return Optional.ofNullable(this.allowPoolSuspension);
        }

        public Optional<Boolean> autoCommit() {
            return Optional.ofNullable(this.autoCommit);
        }

        public Optional<String> catalog() {
            return Optional.ofNullable(this.catalog);
        }

        public Optional<String> connectionInitSql() {
            return Optional.ofNullable(this.connectionInitSql);
        }

        public Optional<String> connectionTestQuery() {
            return Optional.ofNullable(this.connectionTestQuery);
        }

        public Optional<Long> connectionTimeout() {
            return Optional.ofNullable(this.connectionTimeout);
        }

        public Map<String, String> healthCheckProperties() {
            return this.healthCheckProperties;
        }

        public Optional<Long> idleTimeout() {
            return Optional.ofNullable(this.idleTimeout);
        }

        public Optional<Long> initializationFailTimeout() {
            return Optional.ofNullable(this.initializationFailTimeout);
        }

        public Optional<Boolean> isolateInternalQueries() {
            return Optional.ofNullable(this.isolateInternalQueries);
        }

        public Optional<Long> keepaliveTime() {
            return Optional.ofNullable(this.keepaliveTime);
        }

        public Optional<Long> leakDetectionThreshold() {
            return Optional.ofNullable(this.leakDetectionThreshold);
        }

        public Optional<Integer> maximumPoolSize() {
            return Optional.ofNullable(this.maximumPoolSize);
        }

        public Optional<Long> maxLifetime() {
            return Optional.ofNullable(this.maxLifetime);
        }

        public Optional<Integer> minimumIdle() {
            return Optional.ofNullable(this.minimumIdle);
        }

        public Optional<String> poolName() {
            return Optional.ofNullable(this.poolName);
        }

        public Optional<Boolean> readOnly() {
            return Optional.ofNullable(this.readOnly);
        }

        public Optional<Boolean> registerMbeans() {
            return Optional.ofNullable(this.registerMbeans);
        }

        public Optional<String> schema() {
            return Optional.ofNullable(this.schema);
        }

        public Optional<TransactionIsolation> transactionIsolation() {
            return Optional.ofNullable(this.transactionIsolation);
        }

        public Optional<Long> validationTimeout() {
            return Optional.ofNullable(this.validationTimeout);
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public String toString() {
            return "HikariDataSourceConfigBuilder{name=" + this.name + ",allowPoolSuspension=" + this.allowPoolSuspension + ",autoCommit=" + this.autoCommit + ",catalog=" + this.catalog + ",connectionInitSql=" + this.connectionInitSql + ",connectionTestQuery=" + this.connectionTestQuery + ",connectionTimeout=" + this.connectionTimeout + ",healthCheckProperties=" + String.valueOf(this.healthCheckProperties) + ",idleTimeout=" + this.idleTimeout + ",initializationFailTimeout=" + this.initializationFailTimeout + ",isolateInternalQueries=" + this.isolateInternalQueries + ",keepaliveTime=" + this.keepaliveTime + ",leakDetectionThreshold=" + this.leakDetectionThreshold + ",maximumPoolSize=" + this.maximumPoolSize + ",maxLifetime=" + this.maxLifetime + ",minimumIdle=" + this.minimumIdle + ",poolName=" + this.poolName + ",readOnly=" + this.readOnly + ",registerMbeans=" + this.registerMbeans + ",schema=" + this.schema + ",transactionIsolation=" + String.valueOf(this.transactionIsolation) + ",validationTimeout=" + this.validationTimeout + ",properties=" + String.valueOf(this.properties) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(((Object)((Object)this)).getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER allowPoolSuspension(Optional<Boolean> allowPoolSuspension) {
            Objects.requireNonNull(allowPoolSuspension);
            this.allowPoolSuspension = allowPoolSuspension.orElse(this.allowPoolSuspension);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER autoCommit(Optional<Boolean> autoCommit) {
            Objects.requireNonNull(autoCommit);
            this.autoCommit = autoCommit.orElse(this.autoCommit);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER catalog(Optional<String> catalog) {
            Objects.requireNonNull(catalog);
            this.catalog = catalog.orElse(this.catalog);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionInitSql(Optional<String> connectionInitSql) {
            Objects.requireNonNull(connectionInitSql);
            this.connectionInitSql = connectionInitSql.orElse(this.connectionInitSql);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionTestQuery(Optional<String> connectionTestQuery) {
            Objects.requireNonNull(connectionTestQuery);
            this.connectionTestQuery = connectionTestQuery.orElse(this.connectionTestQuery);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER connectionTimeout(Optional<Long> connectionTimeout) {
            Objects.requireNonNull(connectionTimeout);
            this.connectionTimeout = connectionTimeout.orElse(this.connectionTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER idleTimeout(Optional<Long> idleTimeout) {
            Objects.requireNonNull(idleTimeout);
            this.idleTimeout = idleTimeout.orElse(this.idleTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER initializationFailTimeout(Optional<Long> initializationFailTimeout) {
            Objects.requireNonNull(initializationFailTimeout);
            this.initializationFailTimeout = initializationFailTimeout.orElse(this.initializationFailTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER isolateInternalQueries(Optional<Boolean> isolateInternalQueries) {
            Objects.requireNonNull(isolateInternalQueries);
            this.isolateInternalQueries = isolateInternalQueries.orElse(this.isolateInternalQueries);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER keepaliveTime(Optional<Long> keepaliveTime) {
            Objects.requireNonNull(keepaliveTime);
            this.keepaliveTime = keepaliveTime.orElse(this.keepaliveTime);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER leakDetectionThreshold(Optional<Long> leakDetectionThreshold) {
            Objects.requireNonNull(leakDetectionThreshold);
            this.leakDetectionThreshold = leakDetectionThreshold.orElse(this.leakDetectionThreshold);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maximumPoolSize(Optional<Integer> maximumPoolSize) {
            Objects.requireNonNull(maximumPoolSize);
            this.maximumPoolSize = maximumPoolSize.orElse(this.maximumPoolSize);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER maxLifetime(Optional<Long> maxLifetime) {
            Objects.requireNonNull(maxLifetime);
            this.maxLifetime = maxLifetime.orElse(this.maxLifetime);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER minimumIdle(Optional<Integer> minimumIdle) {
            Objects.requireNonNull(minimumIdle);
            this.minimumIdle = minimumIdle.orElse(this.minimumIdle);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER poolName(Optional<String> poolName) {
            Objects.requireNonNull(poolName);
            this.poolName = poolName.orElse(this.poolName);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER readOnly(Optional<Boolean> readOnly) {
            Objects.requireNonNull(readOnly);
            this.readOnly = readOnly.orElse(this.readOnly);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER registerMbeans(Optional<Boolean> registerMbeans) {
            Objects.requireNonNull(registerMbeans);
            this.registerMbeans = registerMbeans.orElse(this.registerMbeans);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER schema(Optional<String> schema) {
            Objects.requireNonNull(schema);
            this.schema = schema.orElse(this.schema);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER transactionIsolation(Optional<? extends TransactionIsolation> transactionIsolation) {
            Objects.requireNonNull(transactionIsolation);
            this.transactionIsolation = transactionIsolation.map(TransactionIsolation.class::cast).orElse(this.transactionIsolation);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        BUILDER validationTimeout(Optional<Long> validationTimeout) {
            Objects.requireNonNull(validationTimeout);
            this.validationTimeout = validationTimeout.orElse(this.validationTimeout);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        protected static class HikariDataSourceConfigImpl
        extends ConnectionConfig.BuilderBase.ConnectionConfigImpl
        implements HikariDataSourceConfig {
            private final Map<String, String> healthCheckProperties;
            private final Map<String, String> properties;
            private final Optional<TransactionIsolation> transactionIsolation;
            private final Optional<Boolean> allowPoolSuspension;
            private final Optional<Boolean> autoCommit;
            private final Optional<Boolean> isolateInternalQueries;
            private final Optional<Boolean> readOnly;
            private final Optional<Boolean> registerMbeans;
            private final Optional<Integer> maximumPoolSize;
            private final Optional<Integer> minimumIdle;
            private final Optional<Long> connectionTimeout;
            private final Optional<Long> idleTimeout;
            private final Optional<Long> initializationFailTimeout;
            private final Optional<Long> keepaliveTime;
            private final Optional<Long> leakDetectionThreshold;
            private final Optional<Long> maxLifetime;
            private final Optional<Long> validationTimeout;
            private final Optional<String> catalog;
            private final Optional<String> connectionInitSql;
            private final Optional<String> connectionTestQuery;
            private final Optional<String> poolName;
            private final Optional<String> schema;
            private final String name;

            protected HikariDataSourceConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.name = builder.name().get();
                this.allowPoolSuspension = builder.allowPoolSuspension().map(Function.identity());
                this.autoCommit = builder.autoCommit().map(Function.identity());
                this.catalog = builder.catalog().map(Function.identity());
                this.connectionInitSql = builder.connectionInitSql().map(Function.identity());
                this.connectionTestQuery = builder.connectionTestQuery().map(Function.identity());
                this.connectionTimeout = builder.connectionTimeout().map(Function.identity());
                this.healthCheckProperties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.healthCheckProperties()));
                this.idleTimeout = builder.idleTimeout().map(Function.identity());
                this.initializationFailTimeout = builder.initializationFailTimeout().map(Function.identity());
                this.isolateInternalQueries = builder.isolateInternalQueries().map(Function.identity());
                this.keepaliveTime = builder.keepaliveTime().map(Function.identity());
                this.leakDetectionThreshold = builder.leakDetectionThreshold().map(Function.identity());
                this.maximumPoolSize = builder.maximumPoolSize().map(Function.identity());
                this.maxLifetime = builder.maxLifetime().map(Function.identity());
                this.minimumIdle = builder.minimumIdle().map(Function.identity());
                this.poolName = builder.poolName().map(Function.identity());
                this.readOnly = builder.readOnly().map(Function.identity());
                this.registerMbeans = builder.registerMbeans().map(Function.identity());
                this.schema = builder.schema().map(Function.identity());
                this.transactionIsolation = builder.transactionIsolation().map(Function.identity());
                this.validationTimeout = builder.validationTimeout().map(Function.identity());
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.properties()));
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<Boolean> allowPoolSuspension() {
                return this.allowPoolSuspension;
            }

            @Override
            public Optional<Boolean> autoCommit() {
                return this.autoCommit;
            }

            @Override
            public Optional<String> catalog() {
                return this.catalog;
            }

            @Override
            public Optional<String> connectionInitSql() {
                return this.connectionInitSql;
            }

            @Override
            public Optional<String> connectionTestQuery() {
                return this.connectionTestQuery;
            }

            @Override
            public Optional<Long> connectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public Map<String, String> healthCheckProperties() {
                return this.healthCheckProperties;
            }

            @Override
            public Optional<Long> idleTimeout() {
                return this.idleTimeout;
            }

            @Override
            public Optional<Long> initializationFailTimeout() {
                return this.initializationFailTimeout;
            }

            @Override
            public Optional<Boolean> isolateInternalQueries() {
                return this.isolateInternalQueries;
            }

            @Override
            public Optional<Long> keepaliveTime() {
                return this.keepaliveTime;
            }

            @Override
            public Optional<Long> leakDetectionThreshold() {
                return this.leakDetectionThreshold;
            }

            @Override
            public Optional<Integer> maximumPoolSize() {
                return this.maximumPoolSize;
            }

            @Override
            public Optional<Long> maxLifetime() {
                return this.maxLifetime;
            }

            @Override
            public Optional<Integer> minimumIdle() {
                return this.minimumIdle;
            }

            @Override
            public Optional<String> poolName() {
                return this.poolName;
            }

            @Override
            public Optional<Boolean> readOnly() {
                return this.readOnly;
            }

            @Override
            public Optional<Boolean> registerMbeans() {
                return this.registerMbeans;
            }

            @Override
            public Optional<String> schema() {
                return this.schema;
            }

            @Override
            public Optional<TransactionIsolation> transactionIsolation() {
                return this.transactionIsolation;
            }

            @Override
            public Optional<Long> validationTimeout() {
                return this.validationTimeout;
            }

            @Override
            public Map<String, String> properties() {
                return this.properties;
            }

            public String toString() {
                return "HikariDataSourceConfig{name=" + this.name + ",allowPoolSuspension=" + String.valueOf(this.allowPoolSuspension) + ",autoCommit=" + String.valueOf(this.autoCommit) + ",catalog=" + String.valueOf(this.catalog) + ",connectionInitSql=" + String.valueOf(this.connectionInitSql) + ",connectionTestQuery=" + String.valueOf(this.connectionTestQuery) + ",connectionTimeout=" + String.valueOf(this.connectionTimeout) + ",healthCheckProperties=" + String.valueOf(this.healthCheckProperties) + ",idleTimeout=" + String.valueOf(this.idleTimeout) + ",initializationFailTimeout=" + String.valueOf(this.initializationFailTimeout) + ",isolateInternalQueries=" + String.valueOf(this.isolateInternalQueries) + ",keepaliveTime=" + String.valueOf(this.keepaliveTime) + ",leakDetectionThreshold=" + String.valueOf(this.leakDetectionThreshold) + ",maximumPoolSize=" + String.valueOf(this.maximumPoolSize) + ",maxLifetime=" + String.valueOf(this.maxLifetime) + ",minimumIdle=" + String.valueOf(this.minimumIdle) + ",poolName=" + String.valueOf(this.poolName) + ",readOnly=" + String.valueOf(this.readOnly) + ",registerMbeans=" + String.valueOf(this.registerMbeans) + ",schema=" + String.valueOf(this.schema) + ",transactionIsolation=" + String.valueOf(this.transactionIsolation) + ",validationTimeout=" + String.valueOf(this.validationTimeout) + ",properties=" + String.valueOf(this.properties) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HikariDataSourceConfig)) {
                    return false;
                }
                HikariDataSourceConfig other = (HikariDataSourceConfig)o;
                return super.equals((Object)other) && Objects.equals(this.name, other.name()) && Objects.equals(this.allowPoolSuspension, other.allowPoolSuspension()) && Objects.equals(this.autoCommit, other.autoCommit()) && Objects.equals(this.catalog, other.catalog()) && Objects.equals(this.connectionInitSql, other.connectionInitSql()) && Objects.equals(this.connectionTestQuery, other.connectionTestQuery()) && Objects.equals(this.connectionTimeout, other.connectionTimeout()) && Objects.equals(this.healthCheckProperties, other.healthCheckProperties()) && Objects.equals(this.idleTimeout, other.idleTimeout()) && Objects.equals(this.initializationFailTimeout, other.initializationFailTimeout()) && Objects.equals(this.isolateInternalQueries, other.isolateInternalQueries()) && Objects.equals(this.keepaliveTime, other.keepaliveTime()) && Objects.equals(this.leakDetectionThreshold, other.leakDetectionThreshold()) && Objects.equals(this.maximumPoolSize, other.maximumPoolSize()) && Objects.equals(this.maxLifetime, other.maxLifetime()) && Objects.equals(this.minimumIdle, other.minimumIdle()) && Objects.equals(this.poolName, other.poolName()) && Objects.equals(this.readOnly, other.readOnly()) && Objects.equals(this.registerMbeans, other.registerMbeans()) && Objects.equals(this.schema, other.schema()) && Objects.equals(this.transactionIsolation, other.transactionIsolation()) && Objects.equals(this.validationTimeout, other.validationTimeout()) && Objects.equals(this.properties, other.properties());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.name, this.allowPoolSuspension, this.autoCommit, this.catalog, this.connectionInitSql, this.connectionTestQuery, this.connectionTimeout, this.healthCheckProperties, this.idleTimeout, this.initializationFailTimeout, this.isolateInternalQueries, this.keepaliveTime, this.leakDetectionThreshold, this.maximumPoolSize, this.maxLifetime, this.minimumIdle, this.poolName, this.readOnly, this.registerMbeans, this.schema, this.transactionIsolation, this.validationTimeout, this.properties);
            }
        }
    }
}

