/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.hikari;

import io.helidon.data.sql.datasource.DataSourceConfig;
import io.helidon.data.sql.datasource.ProviderConfig;
import io.helidon.data.sql.datasource.hikari.HikariDataSourceConfig;
import io.helidon.data.sql.datasource.hikari.HikariDataSourceFactory;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;

@Service.Named(value="*")
@Service.Singleton
class HikariDataSourceProviderService
implements Service.ServicesFactory<DataSource> {
    static final String PROVIDER_TYPE = "hikari";
    private final Supplier<List<DataSourceConfig>> dsConfigs;

    @Service.Inject
    HikariDataSourceProviderService(Supplier<List<DataSourceConfig>> dsConfigs) {
        this.dsConfigs = dsConfigs;
    }

    public List<Service.QualifiedInstance<DataSource>> services() {
        ArrayList<Service.QualifiedInstance<DataSource>> instances = new ArrayList<Service.QualifiedInstance<DataSource>>();
        for (DataSourceConfig dsConfig : this.dsConfigs.get()) {
            ProviderConfig providerConfig = dsConfig.provider();
            if (!(providerConfig instanceof HikariDataSourceConfig)) continue;
            HikariDataSourceConfig hikariConfig = (HikariDataSourceConfig)providerConfig;
            String name = dsConfig.name();
            instances.add(this.createDataSource(name, hikariConfig));
        }
        return instances;
    }

    private Service.QualifiedInstance<DataSource> createDataSource(String name, HikariDataSourceConfig providerConfig) {
        return Service.QualifiedInstance.create((Object)HikariDataSourceFactory.create(providerConfig), (Qualifier[])new Qualifier[]{Qualifier.createNamed((String)name)});
    }
}

