/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.data.codegen.common.BaseRepositoryGenerator;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceGenerator;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceTypes;

final class JakartaRepositoryClassGenerator {
    private JakartaRepositoryClassGenerator() {
    }

    static void generate(CodegenContext codegenContext, RoundContext roundContext, RepositoryGenerator repositoryGenerator, RepositoryInfo repositoryInfo, TypeName className, ClassModel.Builder classModel, JakartaPersistenceGenerator generator) {
        TypeName repositoryInterface = repositoryInfo.interfaceInfo().typeName();
        ((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)classModel.type(className).copyright(CodegenUtil.copyright((TypeName)JakartaPersistenceGenerator.GENERATOR, (TypeName)repositoryInterface, (TypeName)className)).addAnnotation(JakartaPersistenceTypes.INJECTION_SINGLETON)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)JakartaPersistenceGenerator.GENERATOR, (TypeName)repositoryInterface, (TypeName)className, (String)"1", (String)""))).classType(ElementKind.CLASS)).accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(repositoryInterface);
        JakartaRepositoryClassGenerator.generateFields(classModel);
        JakartaRepositoryClassGenerator.generateConstructor(classModel, repositoryInfo);
        repositoryGenerator.generateInterfaces(repositoryInfo, classModel, codegenContext, (PersistenceGenerator)generator);
        repositoryGenerator.generateQueryMethods(repositoryInfo, classModel, codegenContext, (PersistenceGenerator)generator);
        if (BaseRepositoryGenerator.hasInterface((TypeInfo)repositoryInfo.interfaceInfo(), (TypeName)JakartaPersistenceTypes.SESSION_REPOSITORY)) {
            JakartaRepositoryClassGenerator.generateSessionRepository(classModel);
        }
        JakartaRepositoryClassGenerator.generateCloseMethod(classModel);
    }

    private static void generateSessionRepository(ClassModel.Builder classModel) {
        classModel.addMethod(JakartaRepositoryClassGenerator::generateRunMethod);
        classModel.addMethod(JakartaRepositoryClassGenerator::generateCallMethod);
    }

    private static void generateRunMethod(Method.Builder builder) {
        ((Method.Builder)((Method.Builder)builder.name("run")).addAnnotation(Annotations.OVERRIDE)).addParameter(((Parameter.Builder)Parameter.builder().name("task")).type(JakartaPersistenceTypes.SESSION_CONSUMER).build());
        builder.addContentLine("executor.run(task::accept);");
    }

    private static void generateCallMethod(Method.Builder builder) {
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("call")).addAnnotation(Annotations.OVERRIDE)).addParameter(((Parameter.Builder)Parameter.builder().name("task")).type(JakartaPersistenceTypes.SESSION_FUNCTION).build())).returnType((TypeName)JakartaPersistenceTypes.GENERIC_R).addGenericArgument(JakartaPersistenceTypes.GENERIC_R);
        builder.addContentLine("return executor.call(task::apply);");
    }

    private static void generateCloseMethod(ClassModel.Builder classModel) {
        classModel.addMethod(close -> ((Method.Builder)((Method.Builder)((Method.Builder)close.name("close")).addAnnotation(Annotation.create((TypeName)TypeName.create((String)"io.helidon.service.registry.Service.PreDestroy")))).accessModifier(AccessModifier.PACKAGE_PRIVATE)).addContentLine("this.executor.close();"));
    }

    private static void generateFields(ClassModel.Builder classModel) {
        classModel.addField(builder -> ((Field.Builder)builder.name("executor")).isFinal(true).type(JakartaPersistenceTypes.BASE_REPOSITORY_EXECUTOR));
    }

    private static void generateConstructor(ClassModel.Builder classModel, RepositoryInfo repositoryInfo) {
        Constructor.Builder ctr = (Constructor.Builder)Constructor.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE);
        boolean hasNamed = false;
        String name = null;
        boolean nameRequired = false;
        if (repositoryInfo.interfaceInfo().hasAnnotation(JakartaPersistenceTypes.PU_NAME_ANNOTATION)) {
            Annotation dataSourceAnnotation = repositoryInfo.interfaceInfo().annotation(JakartaPersistenceTypes.PU_NAME_ANNOTATION);
            name = dataSourceAnnotation.value().orElse("@default");
            nameRequired = dataSourceAnnotation.booleanValue("required").orElse(false);
            boolean bl = hasNamed = !name.equals("@default");
        }
        if (hasNamed) {
            Annotation named = ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(TypeName.create((String)"io.helidon.service.registry.Service.Named"))).putValue("value", name)).build();
            if (nameRequired) {
                ((Constructor.Builder)ctr.addParameter(((Parameter.Builder)((Parameter.Builder)Parameter.builder().addAnnotation(named)).name("executor")).type(JakartaPersistenceTypes.BASE_REPOSITORY_EXECUTOR).build())).addContent("this.executor = executor;");
            } else {
                ((Constructor.Builder)((Constructor.Builder)ctr.addParameter(((Parameter.Builder)((Parameter.Builder)Parameter.builder().addAnnotation(named)).name("namedExecutor")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(JakartaPersistenceTypes.BASE_REPOSITORY_EXECUTOR)).build()).build())).addParameter(((Parameter.Builder)Parameter.builder().name("executor")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(JakartaPersistenceTypes.BASE_REPOSITORY_EXECUTOR)).build()).build())).addContent("this.executor = namedExecutor.orElseGet(executor);");
            }
        } else {
            ((Constructor.Builder)ctr.addParameter(((Parameter.Builder)Parameter.builder().name("executor")).type(JakartaPersistenceTypes.BASE_REPOSITORY_EXECUTOR).build())).addContent("this.executor = executor;");
        }
        classModel.addConstructor(ctr);
    }
}

