/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.common.BaseGenerator;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceCriteriaQueryGenerator;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceTypes;
import java.util.List;
import java.util.function.Consumer;

final class JakartaStatementGenerator
extends BaseGenerator
implements PersistenceGenerator.StatementGenerator {
    JakartaStatementGenerator() {
    }

    public TypeName executorType() {
        return JakartaPersistenceTypes.EXECUTOR;
    }

    public void addPersist(Method.Builder builder, String identifier) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmPersist(b, identifier));
    }

    public void addMerge(Method.Builder builder, String identifier) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmMerge(b, identifier));
    }

    public void addPersistCollection(Method.Builder builder, String identifier) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmPersistCollection(b, identifier));
    }

    public void addMergeCollection(Method.Builder builder, String identifier, String merged) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmMergeCollection(b, identifier, merged));
    }

    public void addRemove(Method.Builder builder, String identifier) {
        JakartaStatementGenerator.addEmLambda(builder, b1 -> JakartaStatementGenerator.addEmRemove(b1, b2 -> {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)b2.addContent("em.contains(")).addContent(identifier)).addContent(") ? ")).addContent(identifier)).addContent(" : ");
            JakartaStatementGenerator.addEmMerge(b2, identifier);
        }));
    }

    public void addRemoveCollection(Method.Builder builder, String identifier) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmRemoveCollection(b, identifier));
    }

    public void addFind(Method.Builder builder, String identifier, TypeName entity) {
        JakartaStatementGenerator.addEmLambda(builder, b -> JakartaStatementGenerator.addEmFind(b, identifier, entity));
    }

    public void addUpdate(Method.Builder builder, String executor, String identifier, TypeName entity) {
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            JakartaStatementGenerator.statement((Method.Builder)b, b1 -> JakartaStatementGenerator.initializedVariable((Method.Builder)b1, (TypeName)OBJECT, (String)"id", b2 -> ((Method.Builder)((Method.Builder)((Method.Builder)b2.addContent(executor)).addContent(".persistenceUnitUtil().getIdentifier(")).addContent(identifier)).addContent(")")));
            b.addContentLine("if (id != null) {");
            JakartaStatementGenerator.statement((Method.Builder)b, b1 -> JakartaStatementGenerator.initializedVariable((Method.Builder)b, (TypeName)entity, (String)"srcEntity", b2 -> JakartaStatementGenerator.addEmFind(b2, "id", entity)));
            b.addContentLine("if (srcEntity != null) {");
            JakartaStatementGenerator.returnStatement((Method.Builder)b, b1 -> JakartaStatementGenerator.addEmMerge(b1, identifier));
            b.addContentLine("}");
            JakartaStatementGenerator.statement((Method.Builder)b, b1 -> JakartaStatementGenerator.throwException((Method.Builder)b1, (TypeName)JakartaPersistenceTypes.DATA_EXCEPTION, b3 -> b3.addContent("String.format(\"Entity with id = \\\"%s\\\" does not exist.\", id)")));
            b.addContentLine("}");
            JakartaStatementGenerator.statement((Method.Builder)b, b1 -> JakartaStatementGenerator.throwException((Method.Builder)b1, (TypeName)JakartaPersistenceTypes.DATA_EXCEPTION, (String)"Entity does not have ID value set."));
        });
    }

    public void addUpdateAll(Method.Builder builder, String executor, String srcEntities, String updatedEntities, TypeName entity) {
        JakartaStatementGenerator.addEmLambda(builder, b1 -> {
            ((Method.Builder)b1.addContent(srcEntities)).addContentLine(".forEach(e -> {");
            JakartaStatementGenerator.statement((Method.Builder)b1, b2 -> JakartaStatementGenerator.initializedVariable((Method.Builder)b2, (TypeName)OBJECT, (String)"id", b3 -> ((Method.Builder)((Method.Builder)((Method.Builder)b3.addContent(executor)).addContent(".persistenceUnitUtil().getIdentifier(")).addContent("e")).addContent(")")));
            b1.addContentLine("if (id != null) {");
            JakartaStatementGenerator.statement((Method.Builder)b1, b2 -> JakartaStatementGenerator.initializedVariable((Method.Builder)b2, (TypeName)entity, (String)"srcEntity", b3 -> JakartaStatementGenerator.addEmFind(b3, "id", entity)));
            b1.addContentLine("if (srcEntity != null) {");
            JakartaStatementGenerator.statement((Method.Builder)b1, b2 -> {
                b2.addContent("mergedEntities.add(");
                JakartaStatementGenerator.addEmMerge(b2, "e");
                b2.addContent(")");
            });
            ((Method.Builder)b1.addContent("}")).addContentLine(" else {");
            JakartaStatementGenerator.statement((Method.Builder)b1, b2 -> JakartaStatementGenerator.throwException((Method.Builder)b2, (TypeName)JakartaPersistenceTypes.DATA_EXCEPTION, b3 -> b3.addContent("String.format(\"Entity with id = \\\"%s\\\" does not exist.\", id)")));
            b1.addContentLine("}");
            ((Method.Builder)b1.addContent("}")).addContentLine(" else {");
            JakartaStatementGenerator.statement((Method.Builder)b1, b2 -> JakartaStatementGenerator.throwException((Method.Builder)b2, (TypeName)JakartaPersistenceTypes.DATA_EXCEPTION, (String)"Entity does not have ID value set."));
            b1.addContentLine("}");
            ((Method.Builder)b1.addContent("}")).addContent(")");
        });
    }

    public void addExecuteSimpleQueryItem(Method.Builder builder, String query, TypeName returnType) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query, returnType);
            builder.addContentLine("");
            builder.padContent(2);
            JakartaStatementGenerator.addGetSingleResult(builder);
        });
    }

    public void addExecuteSimpleQueryList(Method.Builder builder, String query, TypeName entity) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query, entity);
            builder.addContentLine("");
            builder.padContent(2);
            JakartaStatementGenerator.addGetResultList(builder);
        });
    }

    public void addExecuteSimpleQueryStream(Method.Builder builder, String query, TypeName entity) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query, entity);
            builder.addContentLine("");
            builder.padContent(2);
            JakartaStatementGenerator.addGetResultStream(builder);
        });
    }

    public void addExecuteQueryItem(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, query.settings());
            JakartaStatementGenerator.addGetSingleResult(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteDynamicQueryItem(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            criteriaQueryGenerator.criteriaQuery(builder);
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, criteriaQueryGenerator.settings());
            JakartaStatementGenerator.addGetSingleResult(builder);
            builder.addContentLine(";");
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteQueryItemOrNull(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, query.settings());
            JakartaStatementGenerator.addGetSingleResultOrNull(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteDynamicQueryItemOrNull(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            criteriaQueryGenerator.criteriaQuery(builder);
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, criteriaQueryGenerator.settings());
            JakartaStatementGenerator.addGetSingleResultOrNull(builder);
            builder.addContentLine(";");
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteQueryList(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, query.settings());
            JakartaStatementGenerator.addGetResultList(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteQueryStream(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, query.settings());
            JakartaStatementGenerator.addGetResultStream(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addQueryItem(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType) {
        JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
        builder.addContentLine("");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
        JakartaStatementGenerator.addSettings(builder, query.settings());
        JakartaStatementGenerator.addGetSingleResult(builder);
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
    }

    public void addQueryPage(Method.Builder builder, PersistenceGenerator.Query query, TypeName returnType, String firstResult, String maxResults) {
        JakartaStatementGenerator.addCreateQuery(builder, query.query(), returnType);
        builder.addContentLine("");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
        JakartaStatementGenerator.addSettings(builder, query.settings());
        JakartaStatementGenerator.addFirstResult(builder, firstResult);
        JakartaStatementGenerator.addMaxResults(builder, maxResults);
        JakartaStatementGenerator.addGetResultList(builder);
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
    }

    public void addQueryPage(Method.Builder builder, Consumer<Method.Builder> queryContent, List<PersistenceGenerator.QuerySettings> settings, TypeName returnType, String firstResult, String maxResults) {
        JakartaStatementGenerator.addCreateQuery(builder, queryContent, returnType);
        builder.addContentLine("");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
        JakartaStatementGenerator.addSettings(builder, settings);
        JakartaStatementGenerator.addFirstResult(builder, firstResult);
        JakartaStatementGenerator.addMaxResults(builder, maxResults);
        JakartaStatementGenerator.addGetResultList(builder);
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
    }

    public void addQueryCount(Method.Builder builder, PersistenceGenerator.Query query) {
        JakartaStatementGenerator.addCreateQuery(builder, "SELECT COUNT(*) FROM (" + query.query() + ")", BaseGenerator.NUMBER);
        builder.addContentLine("");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
        JakartaStatementGenerator.addSettings(builder, query.settings());
        JakartaStatementGenerator.addGetSingleResult(builder);
        ((Method.Builder)builder.addContentLine("")).addContent(".intValue()");
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
    }

    public void addQueryCount(Method.Builder builder, Consumer<Method.Builder> queryContent, List<PersistenceGenerator.QuerySettings> settings, TypeName returnType) {
        JakartaStatementGenerator.addCreateQuery(builder, queryContent, returnType);
        builder.addContentLine("");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
        JakartaStatementGenerator.addSettings(builder, settings);
        JakartaStatementGenerator.addGetSingleResult(builder);
        ((Method.Builder)builder.addContentLine("")).addContent(".intValue()");
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
    }

    public List<PersistenceGenerator.QuerySettings> addDynamicSliceQuery(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, String dataQueryStatement, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        return criteriaQueryGenerator.dynamicSliceQuery(builder, dataQueryStatement);
    }

    public List<PersistenceGenerator.QuerySettings> addDynamicPageQueries(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, String dataQueryStatement, String countQueryStatement, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        return criteriaQueryGenerator.dynamicPageQueries(builder, dataQueryStatement, countQueryStatement);
    }

    public void addExecuteSimpleDml(Method.Builder builder, String dml) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, dml);
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addExecuteUpdate(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteDml(Method.Builder builder, PersistenceGenerator.Query dml) {
        JakartaStatementGenerator.addEmLambda(builder, b -> {
            JakartaStatementGenerator.addCreateQuery(builder, dml.query());
            builder.addContentLine("");
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, dml.settings());
            JakartaStatementGenerator.addExecuteUpdate(builder);
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteDynamicQueryList(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            criteriaQueryGenerator.criteriaQuery(builder);
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, criteriaQueryGenerator.settings());
            JakartaStatementGenerator.addGetResultList(builder);
            builder.addContentLine(";");
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addExecuteDynamicQueryStream(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            criteriaQueryGenerator.criteriaQuery(builder);
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, criteriaQueryGenerator.settings());
            JakartaStatementGenerator.addGetResultStream(builder);
            builder.addContentLine(";");
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addDynamicDml(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        JakartaPersistenceCriteriaQueryGenerator criteriaQueryGenerator = JakartaPersistenceCriteriaQueryGenerator.create(repositoryInfo, methodParams, dataQuery, returnType);
        JakartaStatementGenerator.addEmLambdaBlock(builder, b -> {
            criteriaQueryGenerator.criteriaQuery(builder);
            JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)2);
            JakartaStatementGenerator.addSettings(builder, criteriaQueryGenerator.settings());
            JakartaStatementGenerator.addExecuteUpdate(builder);
            builder.addContentLine(";");
            JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)2);
        });
    }

    public void addSessionLambda(Method.Builder builder, Consumer<Method.Builder> content) {
        JakartaStatementGenerator.addEmLambda(builder, content);
    }

    public void addSessionLambdaBlock(Method.Builder builder, Consumer<Method.Builder> content) {
        JakartaStatementGenerator.addEmLambdaBlock(builder, content);
    }

    private static void addCreateQuery(Method.Builder builder, String query, TypeName returnType) {
        ((Method.Builder)((Method.Builder)builder.addContent("em.createQuery(\"")).addContent(query)).addContent("\"");
        if (returnType != null) {
            ((Method.Builder)((Method.Builder)builder.addContent(", ")).addContent(returnType)).addContent(".class");
        }
        builder.addContent(")");
    }

    private static void addCreateQuery(Method.Builder builder, String query) {
        JakartaStatementGenerator.addCreateQuery(builder, query, null);
    }

    private static void addCreateQuery(Method.Builder builder, Consumer<Method.Builder> queryContent, TypeName returnType) {
        builder.addContent("em.createQuery(");
        queryContent.accept(builder);
        if (returnType != null) {
            ((Method.Builder)((Method.Builder)builder.addContent(", ")).addContent(returnType)).addContent(".class");
        }
        builder.addContent(")");
    }

    private static void addSettings(Method.Builder builder, List<PersistenceGenerator.QuerySettings> settings) {
        settings.forEach(setting -> ((Method.Builder)builder.addContent(".")).addContentLine(setting.code().toString()));
    }

    private static void addFirstResult(Method.Builder builder, String firstResult) {
        ((Method.Builder)((Method.Builder)builder.addContent(".setFirstResult(")).addContent(firstResult)).addContentLine(")");
    }

    private static void addMaxResults(Method.Builder builder, String maxResults) {
        ((Method.Builder)((Method.Builder)builder.addContent(".setMaxResults(")).addContent(maxResults)).addContentLine(")");
    }

    private static void addGetSingleResult(Method.Builder builder) {
        builder.addContent(".getSingleResult()");
    }

    private static void addGetSingleResultOrNull(Method.Builder builder) {
        builder.addContent(".getSingleResultOrNull()");
    }

    private static void addGetResultList(Method.Builder builder) {
        builder.addContent(".getResultList()");
    }

    private static void addGetResultStream(Method.Builder builder) {
        builder.addContentLine(".getResultList().stream()");
    }

    private static void addExecuteUpdate(Method.Builder builder) {
        builder.addContent(".executeUpdate()");
    }

    private static void addEmLambda(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("em -> ");
        content.accept(builder);
    }

    private static void addEmLambdaBlock(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContentLine("em -> {");
        JakartaStatementGenerator.increasePadding((Method.Builder)builder, (int)1);
        content.accept(builder);
        JakartaStatementGenerator.decreasePadding((Method.Builder)builder, (int)1);
        builder.addContent("}");
    }

    private static void addEmPersist(Method.Builder builder, String identifier) {
        ((Method.Builder)((Method.Builder)builder.addContent("em.persist(")).addContent(identifier)).addContent(")");
    }

    private static void addEmMerge(Method.Builder builder, String identifier) {
        ((Method.Builder)((Method.Builder)builder.addContent("em.merge(")).addContent(identifier)).addContent(")");
    }

    private static void addEmPersistCollection(Method.Builder builder, String identifier) {
        ((Method.Builder)builder.addContent(identifier)).addContent(".forEach(em::persist)");
    }

    private static void addEmMergeCollection(Method.Builder builder, String identifier, String merged) {
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(identifier)).addContent(".forEach(e -> ")).addContent(merged)).addContent(".add(em.merge(e)))");
    }

    private static void addEmRemove(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("em.remove(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void addEmRemoveCollection(Method.Builder builder, String identifier) {
        ((Method.Builder)builder.addContent(identifier)).addContent(".forEach(e -> ");
        JakartaStatementGenerator.addEmRemove(builder, b -> {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)b.addContent("em.contains(")).addContent("e")).addContent(") ? ")).addContent("e")).addContent(" : ");
            JakartaStatementGenerator.addEmMerge(b, "e");
        });
        builder.addContent(")");
    }

    private static void addEmFind(Method.Builder builder, String identifier, TypeName entity) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("em.find(")).addContent(entity)).addContent(".class, ")).addContent(identifier)).addContent(")");
    }
}

