/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.QueryParameters;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceBaseQueryBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class JakartaPersistenceQueryStringBuilder
extends JakartaPersistenceBaseQueryBuilder {
    private final List<PersistenceGenerator.QueryBuilder.MethodParameter> methodParameters;
    private final QueryParameters queryParameters;
    private final Map<String, CharSequence> paramsAliases;
    private final Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter;
    private final JakartaPersistenceBaseQueryBuilder.Query.Builder queryBuilder;

    private JakartaPersistenceQueryStringBuilder(RepositoryInfo repositoryInfo, QueryParameters queryParameters, List<PersistenceGenerator.QueryBuilder.MethodParameter> methodParameters) {
        super(repositoryInfo);
        this.methodParameters = methodParameters;
        this.queryParameters = queryParameters;
        this.paramsAliases = methodParameters.stream().collect(Collectors.toMap(JakartaPersistenceQueryStringBuilder::parameterAlias, PersistenceGenerator.QueryBuilder.MethodParameter::name));
        this.setParameter = new HashMap<CharSequence, PersistenceGenerator.QuerySettings>();
        this.queryBuilder = JakartaPersistenceBaseQueryBuilder.Query.builder();
    }

    static JakartaPersistenceQueryStringBuilder create(RepositoryInfo repositoryInfo, QueryParameters queryParameters, List<PersistenceGenerator.QueryBuilder.MethodParameter> methodParameters) {
        return new JakartaPersistenceQueryStringBuilder(repositoryInfo, queryParameters, methodParameters);
    }

    PersistenceGenerator.Query buildQuery(String query) {
        this.queryBuilder.query(query);
        if (!this.queryParameters.isEmpty()) {
            switch (this.queryParameters.type()) {
                case NAMED: {
                    this.queryParameters.parameters().forEach(this::namedParameterSettings);
                    break;
                }
                case ORDINAL: {
                    this.queryParameters.parameters().forEach(this::ordinalParameterSettings);
                    break;
                }
                default: {
                    throw new CodegenException("Unknown query parameter type " + String.valueOf(this.queryParameters.type()));
                }
            }
        }
        this.setParameter.values().forEach(this.queryBuilder::setting);
        this.queryBuilder.isDml(false);
        this.queryBuilder.returnType(PersistenceGenerator.QueryReturnType.ENTITY);
        return this.queryBuilder.build();
    }

    private static String parameterAlias(PersistenceGenerator.QueryBuilder.MethodParameter param) {
        return param.alias().toString();
    }

    private void namedParameterSettings(QueryParameters.Parameter queryParameter) {
        CharSequence methodParameter = this.paramsAliases.get(queryParameter.name());
        if (methodParameter == null) {
            throw new CodegenException("Method parameter " + queryParameter.name() + " is missing");
        }
        this.setParameter.putIfAbsent(queryParameter.name(), new Param(queryParameter, methodParameter));
    }

    private void ordinalParameterSettings(QueryParameters.Parameter queryParameter) {
        int queryParameterIndex = queryParameter.index() - 1;
        if (this.methodParameters.size() <= queryParameterIndex) {
            throw new CodegenException("Method parameter with index " + queryParameter.index() + "is missing");
        }
        this.setParameter.putIfAbsent(queryParameter.name(), new Param(queryParameter, this.methodParameters.get(queryParameterIndex).name()));
    }

    private record Param(QueryParameters.Parameter queryParameter, CharSequence methodParameter) implements PersistenceGenerator.QuerySettings
    {
        private static final String SET = "setParameter";

        public CharSequence code() {
            return new StringBuilder(SET.length() + this.queryParameter.code().length() + this.methodParameter.length() + 6).append(SET).append('(').append(this.queryParameter.code()).append(',').append(' ').append(this.methodParameter).append(')');
        }
    }
}

