/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.CriteriaCondition;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.LogicalOperator;
import io.helidon.data.codegen.query.OrderExpression;
import io.helidon.data.codegen.query.Projection;
import io.helidon.data.codegen.query.ProjectionExpression;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceBaseBuilder;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceBaseQueryBuilder;
import io.helidon.data.jakarta.persistence.codegen.JpqlKeywords;
import java.util.Collection;
import java.util.Iterator;

final class JakartaPersistenceDataQueryBuilder
extends JakartaPersistenceBaseQueryBuilder {
    private final String entityAlias;
    private final StringBuilder jpql;

    private JakartaPersistenceDataQueryBuilder(RepositoryInfo repositoryInfo) {
        super(repositoryInfo);
        this.entityAlias = RepositoryInfo.entityAlias((String)repositoryInfo.entity().className());
        this.jpql = new StringBuilder();
    }

    static JakartaPersistenceDataQueryBuilder create(RepositoryInfo repositoryInfo) {
        return new JakartaPersistenceDataQueryBuilder(repositoryInfo);
    }

    PersistenceGenerator.Query buildQuery(DataQuery query, Collection<CharSequence> parameters) {
        Iterator<CharSequence> parametersIterator = parameters.iterator();
        JakartaPersistenceBaseQueryBuilder.Query.Builder queryBuilder = JakartaPersistenceBaseQueryBuilder.Query.builder();
        this.buildProjection(query, queryBuilder);
        this.buildCriteria(query, parametersIterator);
        this.buildOrder(query);
        queryBuilder.query(this.jpql.toString());
        this.setParameter().values().forEach(queryBuilder::setting);
        return queryBuilder.build();
    }

    PersistenceGenerator.Query buildCountQuery(DataQuery query, Collection<CharSequence> parameters) {
        Iterator<CharSequence> parametersIterator = parameters.iterator();
        JakartaPersistenceBaseQueryBuilder.Query.Builder queryBuilder = JakartaPersistenceBaseQueryBuilder.Query.builder();
        this.buildCountFromProjection(query, queryBuilder);
        this.buildCriteria(query, parametersIterator);
        queryBuilder.query(this.jpql.toString());
        this.setParameter().values().forEach(queryBuilder::setting);
        return queryBuilder.build();
    }

    private void buildProjection(DataQuery query, JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder<?, ?> queryBuilder) {
        Projection projection = query.projection();
        switch (projection.action()) {
            case Select: {
                ((JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder)queryBuilder.isDml(false)).returnType(PersistenceGenerator.QueryReturnType.ENTITY);
                this.appendSelect(projection, queryBuilder);
                break;
            }
            case Delete: {
                ((JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder)queryBuilder.isDml(true)).returnType(PersistenceGenerator.QueryReturnType.DML);
                this.appendDelete();
                break;
            }
            case Update: {
                ((JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder)queryBuilder.isDml(true)).returnType(PersistenceGenerator.QueryReturnType.DML);
                this.appendUpdate();
                throw new CodegenException("update methods are not supported yet");
            }
            default: {
                throw new CodegenException("Unknown query action " + String.valueOf(projection.action()));
            }
        }
    }

    private void buildCountFromProjection(DataQuery query, JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder<?, ?> queryBuilder) {
        Projection projection = query.projection();
        switch (projection.action()) {
            case Select: {
                this.appendSelectCount(projection, queryBuilder);
                break;
            }
            case Delete: 
            case Update: {
                throw new CodegenException("Cannot build COUNT query from " + String.valueOf(projection.action()) + " statement");
            }
            default: {
                throw new CodegenException("Unknown query action " + String.valueOf(projection.action()));
            }
        }
    }

    private void appendSelect(Projection projection, JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder<?, ?> queryBuilder) {
        this.jpql.append("SELECT");
        this.appendSelectExpression(projection, queryBuilder);
        this.jpql.append(' ').append("FROM").append(' ').append(this.repositoryInfo().entity().className()).append(' ').append(this.entityAlias);
    }

    private void appendSelectExpression(Projection projection, JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder<?, ?> queryBuilder) {
        this.jpql.append(' ');
        projection.expression().ifPresentOrElse(expression -> {
            switch (expression.operator()) {
                case First: {
                    expression.parameter().ifPresentOrElse(parameter -> {
                        if (parameter.type() != Integer.class) {
                            throw new CodegenException("First projection operator parameter is not Integer");
                        }
                        this.jpql.append(this.distinctProperty(projection.distinct(), this.entityAlias));
                        ((JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder)queryBuilder.setting(new JakartaPersistenceBaseBuilder.Limit((Integer)parameter.value()))).returnType(PersistenceGenerator.QueryReturnType.ENTITY);
                    }, () -> {
                        throw new CodegenException("Missing First projection operator parameter");
                    });
                    break;
                }
                case Count: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
                    break;
                }
                case Exists: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.BOOLEAN);
                    break;
                }
                case Min: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.min(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.min(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
                    break;
                }
                case Max: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.max(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.max(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
                    break;
                }
                case Sum: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.sum(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.sum(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
                    break;
                }
                case Avg: {
                    projection.property().ifPresentOrElse(property -> JpqlKeywords.avg(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.avg(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
                    queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
                    break;
                }
                default: {
                    throw new CodegenException("Unknown projection expression operator " + String.valueOf(expression.operator()));
                }
            }
        }, () -> projection.property().ifPresentOrElse(property -> this.jpql.append(this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> this.jpql.append(this.distinctProperty(projection.distinct(), this.entityAlias))));
    }

    private void appendSelectCount(Projection projection, JakartaPersistenceBaseQueryBuilder.BaseQuery.BaseBuilder<?, ?> queryBuilder) {
        if (!projection.expression().isEmpty()) {
            throw new CodegenException("Cannot build COUNT query from statement with " + String.valueOf(((ProjectionExpression)projection.expression().get()).operator()) + " projection expression");
        }
        this.jpql.append("SELECT").append(' ');
        projection.property().ifPresentOrElse(property -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityProperty(property.toString()))), () -> JpqlKeywords.count(this.jpql, this.distinctProperty(projection.distinct(), this.entityAlias)));
        queryBuilder.isDml(false);
        queryBuilder.returnType(PersistenceGenerator.QueryReturnType.NUMBER);
        this.jpql.append(' ').append("FROM").append(' ').append(this.repositoryInfo().entity().className()).append(' ').append(this.entityAlias);
    }

    private CharSequence distinctProperty(boolean distinct, CharSequence identifier) {
        StringBuilder sb = new StringBuilder(this.entityAlias.length() + "DISTINCT".length() + 1);
        if (distinct) {
            sb.append("DISTINCT").append(' ');
        }
        sb.append(identifier);
        return sb;
    }

    private CharSequence entityProperty(CharSequence property) {
        StringBuilder sb = new StringBuilder(this.entityAlias.length() + property.length() + 1);
        sb.append(this.entityAlias).append('.').append(property);
        return sb;
    }

    private void appendDelete() {
        this.jpql.append("DELETE").append(' ').append("FROM").append(' ').append(this.repositoryInfo().entity().className()).append(' ').append(this.entityAlias);
    }

    private void appendUpdate() {
        this.jpql.append("UPDATE").append(' ').append(this.repositoryInfo().entity().className()).append(' ').append(this.entityAlias);
    }

    private void buildCriteria(DataQuery query, Iterator<CharSequence> parameters) {
        query.criteria().ifPresent(criteria -> {
            this.jpql.append(' ').append("WHERE");
            this.appendCriteriaCondition(criteria.first(), parameters);
            criteria.next().forEach(nextExpression -> {
                this.appendLogicalOperator(nextExpression.operator());
                this.appendCriteriaCondition(nextExpression.criteria(), parameters);
            });
        });
    }

    private void appendLogicalOperator(LogicalOperator operatopr) {
        this.jpql.append(' ');
        switch (operatopr) {
            case AND: {
                this.jpql.append("AND");
                break;
            }
            case OR: {
                this.jpql.append("OR");
                break;
            }
            default: {
                throw new CodegenException("Unknown criteria logical operator " + String.valueOf(operatopr));
            }
        }
    }

    private void appendCriteriaCondition(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        switch (expression.operator()) {
            case Equal: {
                this.jpqlEqual(expression, parameters);
                break;
            }
            case Contains: {
                this.jpqlContains(expression, parameters);
                break;
            }
            case EndsWith: {
                this.jpqlEndsWith(expression, parameters);
                break;
            }
            case StartsWith: {
                this.jpqlStartsWith(expression, parameters);
                break;
            }
            case Before: 
            case LessThan: {
                this.jpqlLessThan(expression, parameters);
                break;
            }
            case LessThanEqual: {
                this.jpqlLessThanEqual(expression, parameters);
                break;
            }
            case After: 
            case GreaterThan: {
                this.jpqlGreaterThan(expression, parameters);
                break;
            }
            case GreaterThanEqual: {
                this.jpqlGreaterThanEqual(expression, parameters);
                break;
            }
            case Between: {
                this.jpqlBetween(expression, parameters);
                break;
            }
            case Like: {
                this.jpqlLike(expression, parameters);
                break;
            }
            case In: {
                this.jpqlIn(expression, parameters);
                break;
            }
            case Empty: {
                this.jpqlEmpty(expression);
                break;
            }
            case Null: {
                this.jpqlNull(expression);
                break;
            }
            case True: {
                this.jpqlTrue(expression);
                break;
            }
            case False: {
                this.jpqlFalse(expression);
                break;
            }
            default: {
                throw new CodegenException("Unknown criteria expression operator " + String.valueOf(expression.operator()));
            }
        }
    }

    private void jpqlEqual(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        this.jpql.append(' ').append(expression.not() ? "<>" : Character.valueOf('=')).append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlContains(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("LIKE").append(' ').append("CONCAT").append('(').append('\'').append('%').append('\'').append(',').append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
        this.jpql.append(',').append(' ').append('\'').append('%').append('\'').append(')');
    }

    private void jpqlEndsWith(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("LIKE").append(' ').append("CONCAT").append('(').append('\'').append('%').append('\'').append(',').append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
        this.jpql.append(')');
    }

    private void jpqlStartsWith(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("LIKE").append(' ').append("CONCAT").append('(');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
        this.jpql.append(',').append(' ').append('\'').append('%').append('\'').append(')');
    }

    private void jpqlLessThan(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        this.jpql.append(' ').append(expression.not() ? ">=" : Character.valueOf('<')).append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlLessThanEqual(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        this.jpql.append(' ').append(expression.not() ? Character.valueOf('>') : "<=").append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlGreaterThan(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        this.jpql.append(' ').append(expression.not() ? "<=" : Character.valueOf('>')).append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlGreaterThanEqual(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        this.jpql.append(' ').append(expression.not() ? Character.valueOf('<') : ">=").append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlBetween(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("BETWEEN").append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
        this.jpql.append(' ').append("AND").append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(1), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlLike(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("LIKE").append(' ');
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
    }

    private void jpqlIn(CriteriaCondition expression, Iterator<CharSequence> parameters) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name(), expression.ignoreCase());
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("IN").append(' ');
        if (expression.ignoreCase()) {
            this.jpql.append('(');
        }
        expression.parameters().ifPresentOrElse(params -> this.jpqlParam(params.get(0), expression.ignoreCase()), () -> this.jpqlParam((CharSequence)parameters.next(), expression.ignoreCase()));
        if (expression.ignoreCase()) {
            this.jpql.append(')');
        }
    }

    private void jpqlEmpty(CriteriaCondition expression) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name());
        this.jpql.append(' ').append("IS");
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("EMPTY");
    }

    private void jpqlNull(CriteriaCondition expression) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name());
        this.jpql.append(' ').append("IS");
        JpqlKeywords.maybeNot(this.jpql, expression.not());
        this.jpql.append(' ').append("NULL");
    }

    private void jpqlTrue(CriteriaCondition expression) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name());
        this.jpql.append(' ').append(expression.not() ? "<>" : Character.valueOf('=')).append(' ').append("TRUE");
    }

    private void jpqlFalse(CriteriaCondition expression) {
        this.jpql.append(' ');
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name());
        this.jpql.append(' ').append(expression.not() ? "<>" : Character.valueOf('=')).append(' ').append("FALSE");
    }

    private void jpqlParam(CharSequence param, boolean ignoreCase) {
        JpqlKeywords.param(this.jpql, param, ignoreCase);
        this.setParameter().putIfAbsent(param, new JakartaPersistenceBaseBuilder.Param(param));
    }

    private void buildOrder(DataQuery query) {
        query.order().ifPresent(order -> {
            this.jpql.append(' ').append("ORDER BY").append(' ');
            Iterator expressions = order.expressions().iterator();
            this.appendOrderExpression((OrderExpression)expressions.next(), false);
            while (expressions.hasNext()) {
                this.appendOrderExpression((OrderExpression)expressions.next(), true);
            }
        });
    }

    private void appendOrderExpression(OrderExpression expression, boolean comma) {
        JpqlKeywords.maybeComma(this.jpql, comma);
        JpqlKeywords.property(this.jpql, this.entityAlias, expression.property().name());
        switch (expression.operator()) {
            case ASC: {
                break;
            }
            case DESC: {
                this.jpql.append(' ').append("DESC");
                break;
            }
            default: {
                throw new CodegenException("Unknown order expression operator " + String.valueOf(expression.operator()));
            }
        }
    }
}

