/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data;

import io.helidon.common.types.TypeName;
import io.helidon.data.Page;
import io.helidon.data.PageRequest;
import io.helidon.data.Slice;
import io.helidon.service.registry.Service;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Data {
    private Data() {
        throw new UnsupportedOperationException("No instances of Data are allowed");
    }

    public static interface PageableRepository<E, ID>
    extends GenericRepository<E, ID> {
        public Page<E> pages(PageRequest var1);

        public Slice<E> slices(PageRequest var1);
    }

    public static interface SessionRepository<S> {
        public void run(Consumer<S> var1);

        public <R> R call(Function<S, R> var1);
    }

    public static interface GenericRepository<E, ID> {
    }

    public static interface CrudRepository<E, ID>
    extends BasicRepository<E, ID> {
        public <T extends E> T insert(T var1);

        public <T extends E> Iterable<T> insertAll(Iterable<T> var1);

        public <T extends E> T update(T var1);

        public <T extends E> Iterable<T> updateAll(Iterable<T> var1);
    }

    public static interface BasicRepository<E, ID>
    extends GenericRepository<E, ID> {
        public <T extends E> T save(T var1);

        public <T extends E> Iterable<T> saveAll(Iterable<T> var1);

        public Optional<E> findById(ID var1);

        public boolean existsById(ID var1);

        public Stream<E> findAll();

        public long count();

        public long deleteById(ID var1);

        public void delete(E var1);

        public void deleteAll(Iterable<? extends E> var1);

        public long deleteAll();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Query {
        public String value();
    }

    @Service.Qualifier
    @Target(value={ElementType.TYPE, ElementType.PARAMETER, ElementType.FIELD})
    public static @interface ProviderType {
        public static final TypeName TYPE = TypeName.create(ProviderType.class);

        public String value();
    }

    @Target(value={ElementType.TYPE, ElementType.PARAMETER, ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Provider {
        public String value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PersistenceUnit {
        public String value();

        public boolean required() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Repository {
    }
}

