/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.DataCodegenTypes;
import io.helidon.data.codegen.common.BaseRepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.Projection;

class PageableRepositoryInterfaceGenerator
extends BaseRepositoryInterfaceGenerator {
    protected static final String PAGE_REQUEST_PARAM_NAME = "pageRequest";
    protected static final Parameter PAGE_REQUEST_PARAM = ((Parameter.Builder)Parameter.builder().name("pageRequest")).type(DataCodegenTypes.PAGE_REQUEST).build();

    PageableRepositoryInterfaceGenerator(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        super(repositoryInfo, classModel, codegenContext, persistenceGenerator);
    }

    public void generate() {
        ((ClassModel.Builder)this.classModel().addMethod(this::generateFindAllPages)).addMethod(this::generateFindAllSlices);
    }

    private void generateFindAllPages(Method.Builder builder) {
        TypeName returnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(DataCodegenTypes.PAGE)).addTypeArgument(this.repositoryInfo().entity())).build();
        PersistenceGenerator.Query query = this.queryBuilder().buildQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.select())).build());
        PersistenceGenerator.Query countQuery = this.queryBuilder().buildQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.selectCount())).build());
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("pages")).addAnnotation(Annotations.OVERRIDE)).addParameter(PAGE_REQUEST_PARAM)).returnType(returnType);
        PageableRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> PageableRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.PAGE)).addContentLine(".create(");
            PageableRepositoryInterfaceGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(PAGE_REQUEST_PARAM_NAME)).addContentLine(",");
            this.statementGenerator().addQueryPage(b3, query, this.repositoryInfo().entity(), "pageRequest.offset()", "pageRequest.size()");
            b3.addContentLine(",");
            this.statementGenerator().addQueryItem(b3, countQuery, NUMBER);
            ((Method.Builder)((Method.Builder)b3.addContentLine("")).padContent(2)).addContent(".intValue()");
            b3.addContent(")");
            PageableRepositoryInterfaceGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }

    private void generateFindAllSlices(Method.Builder builder) {
        TypeName returnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(DataCodegenTypes.SLICE)).addTypeArgument(this.repositoryInfo().entity())).build();
        PersistenceGenerator.Query query = this.queryBuilder().buildQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.select())).build());
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("slices")).addAnnotation(Annotations.OVERRIDE)).addParameter(PAGE_REQUEST_PARAM)).returnType(returnType);
        PageableRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> PageableRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.SLICE)).addContentLine(".create(");
            PageableRepositoryInterfaceGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(PAGE_REQUEST_PARAM_NAME)).addContentLine(",");
            this.statementGenerator().addQueryPage(b3, query, this.repositoryInfo().entity(), "pageRequest.offset()", "pageRequest.size()");
            b3.addContent(")");
            PageableRepositoryInterfaceGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }
}

