/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.data.codegen.common.BaseRepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.Criteria;
import io.helidon.data.codegen.query.CriteriaCondition;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.Projection;
import io.helidon.data.codegen.query.Property;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;

class BasicRepositoryInterfaceGenerator
extends BaseRepositoryInterfaceGenerator {
    BasicRepositoryInterfaceGenerator(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        super(repositoryInfo, classModel, codegenContext, persistenceGenerator);
    }

    public void generate() {
        ((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)this.classModel().addMethod(this::generateSave)).addMethod(this::generateSaveAll)).addMethod(this::generateFindById)).addMethod(this::generateExistsById)).addMethod(this::generateFindAll)).addMethod(this::generateCount)).addMethod(this::generateDeleteById)).addMethod(this::generateDelete)).addMethod(this::generateDeleteAllEntities)).addMethod(this::generateDeleteAll);
    }

    private void generateSave(Method.Builder builder) {
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("save")).addAnnotation(Annotations.OVERRIDE)).addParameter(T_ENTITY)).returnType(T).addGenericArgument(BasicRepositoryInterfaceGenerator.extendsType((String)"T", (TypeName)this.repositoryInfo().entity()));
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addMerge(b2, "entity"), (String)"executor"));
    }

    private void generateSaveAll(Method.Builder builder) {
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("saveAll")).addAnnotation(Annotations.OVERRIDE)).addParameter(ITERABLE_T_ENTITIES)).addGenericArgument(BasicRepositoryInterfaceGenerator.extendsType((String)"T", (TypeName)this.repositoryInfo().entity())).returnType(ITERABLE_T);
        BasicRepositoryInterfaceGenerator.statement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.initializedVariable((Method.Builder)b1, (TypeName)LIST_T, (String)"mergedEntities", b2 -> ((Method.Builder)((Method.Builder)b2.addContent("new ")).addContent(ArrayList.class)).addContent("<>()")));
        BasicRepositoryInterfaceGenerator.statement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.run((Method.Builder)b1, b2 -> this.statementGenerator().addMergeCollection(b2, "entities", "mergedEntities"), (String)"executor"));
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b -> BasicRepositoryInterfaceGenerator.identifier((Method.Builder)b, (String)"mergedEntities"));
    }

    private void generateFindById(Method.Builder builder) {
        Parameter id = ((Parameter.Builder)Parameter.builder().name("id")).type(this.repositoryInfo().id()).build();
        TypeName returnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Optional.class)).addTypeArgument(this.repositoryInfo().entity())).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("findById")).addAnnotation(Annotations.OVERRIDE)).addParameter(id)).returnType(returnType);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.optionalOfNullable((Method.Builder)b1, b2 -> BasicRepositoryInterfaceGenerator.call((Method.Builder)b2, b3 -> this.statementGenerator().addFind(b3, "id", this.repositoryInfo().entity()), (String)"executor")));
    }

    private void generateExistsById(Method.Builder builder) {
        Parameter id = ((Parameter.Builder)Parameter.builder().name("id")).type(this.repositoryInfo().id()).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("existsById")).addAnnotation(Annotations.OVERRIDE)).addParameter(id)).returnType(TypeNames.PRIMITIVE_BOOLEAN);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> {
            BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addFind(b2, "id", this.repositoryInfo().entity()), (String)"executor");
            b1.addContent(" != null");
        });
    }

    private void generateFindAll(Method.Builder builder) {
        TypeName returnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Stream.class)).addTypeArgument(this.repositoryInfo().entity())).build();
        String query = this.queryBuilder().buildSimpleQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.select())).build());
        ((Method.Builder)((Method.Builder)builder.name("findAll")).addAnnotation(Annotations.OVERRIDE)).returnType(returnType);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addExecuteSimpleQueryStream(b2, query, this.repositoryInfo().entity()), (String)"executor"));
    }

    private void generateCount(Method.Builder builder) {
        String query = this.queryBuilder().buildSimpleQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.selectCount())).build());
        ((Method.Builder)((Method.Builder)builder.name("count")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.PRIMITIVE_LONG);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addExecuteSimpleQueryItem(b2, query, TypeNames.BOXED_LONG), (String)"executor"));
    }

    private void generateDeleteById(Method.Builder builder) {
        Parameter id = ((Parameter.Builder)Parameter.builder().name("id")).type(this.repositoryInfo().id()).build();
        PersistenceGenerator.Query query = this.queryBuilder().buildQuery(((DataQuery.Builder)((DataQuery.Builder)DataQuery.builder().projection(Projection.delete())).criteria(Criteria.builder().condition(CriteriaCondition.createEqual((Property)Property.create((CharSequence)"id"), (CharSequence)"id")).build())).build());
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("deleteById")).addAnnotation(Annotations.OVERRIDE)).addParameter(id)).returnType(TypeNames.PRIMITIVE_LONG);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)((Method.Builder)b1.addContent("(")).addContent(Long.TYPE)).addContent(") ");
            BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addExecuteDml(b2, query), (String)"executor");
        });
    }

    private void generateDelete(Method.Builder builder) {
        Parameter entity = ((Parameter.Builder)Parameter.builder().name("entity")).type(this.repositoryInfo().entity()).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("delete")).addAnnotation(Annotations.OVERRIDE)).addParameter(entity)).returnType(TypeNames.PRIMITIVE_VOID);
        BasicRepositoryInterfaceGenerator.statement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.run((Method.Builder)b1, b2 -> this.statementGenerator().addRemove(b2, "entity"), (String)"executor"));
    }

    private void generateDeleteAllEntities(Method.Builder builder) {
        Parameter entities = ((Parameter.Builder)Parameter.builder().name("entities")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Iterable.class)).addTypeArgument((TypeName)BasicRepositoryInterfaceGenerator.extendsType((String)"?", (TypeName)this.repositoryInfo().entity()))).build()).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.name("deleteAll")).addAnnotation(Annotations.OVERRIDE)).addParameter(entities)).returnType(TypeNames.PRIMITIVE_VOID);
        BasicRepositoryInterfaceGenerator.statement((Method.Builder)builder, b1 -> BasicRepositoryInterfaceGenerator.run((Method.Builder)b1, b2 -> this.statementGenerator().addRemoveCollection(b2, "entities"), (String)"executor"));
    }

    private void generateDeleteAll(Method.Builder builder) {
        String query = this.queryBuilder().buildSimpleQuery(((DataQuery.Builder)DataQuery.builder().projection(Projection.delete())).build());
        ((Method.Builder)((Method.Builder)builder.name("deleteAll")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.PRIMITIVE_LONG);
        BasicRepositoryInterfaceGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)((Method.Builder)b1.addContent("(")).addContent(Long.TYPE)).addContent(") ");
            BasicRepositoryInterfaceGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addExecuteSimpleDml(b2, query), (String)"executor");
        });
    }
}

